/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.blacklist;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.hadoop.rmi.hbase.Column;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.workflows.blacklist.ResolvedBlacklistEntry;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.openaire.blacklist.BlacklistManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class ResolveBlacklistJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(ResolveBlacklistJobNode.class);
    @Autowired
    private BlacklistManager blacklistManager;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ResultSetClientFactory resultSetClientFactory;
    private String blacklistParamName;
    private String clusterName;
    private String tableName;

    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference epr = this.blacklistManager.getAcceptedBlacklistEntries();
        HadoopService hadoopService = (HadoopService)this.serviceLocator.getService(HadoopService.class);
        HashSet resolved = Sets.newHashSet();
        SAXReader r = new SAXReader();
        for (String s : this.resultSetClientFactory.getClient(epr)) {
            Document doc = r.read((Reader)new StringReader(s));
            if (log.isDebugEnabled()) {
                log.debug((Object)doc.asXML());
            }
            ResolvedBlacklistEntry rbe = new ResolvedBlacklistEntry();
            String source = this.fullId(doc.valueOf("//FIELD[./@name='source_type']"), doc.valueOf("//FIELD[./@name='source']"));
            rbe.setSource(this.getResolvedId(source, hadoopService.describeHBaseColumn(this.getClusterName(), this.getTableName(), source).getColumns()));
            String target = this.fullId(doc.valueOf("//FIELD[./@name='target_type']"), doc.valueOf("//FIELD[./@name='target']"));
            rbe.setTarget(this.getResolvedId(target, hadoopService.describeHBaseColumn(this.getClusterName(), this.getTableName(), target).getColumns()));
            String relType = doc.valueOf("//FIELD[./@name='relationship']");
            rbe.setRelType(relType);
            resolved.add(rbe);
            resolved.add(new ResolvedBlacklistEntry(source, target, relType));
        }
        if (resolved.isEmpty()) {
            log.info((Object)"blacklist is empty, nothing to do");
            return "done";
        }
        log.info((Object)("blacklist size: " + resolved.size()));
        token.getEnv().setAttribute(this.getBlacklistParamName(), new Gson().toJson((Object)resolved));
        return Arc.DEFAULT_ARC;
    }

    private String fullId(String type, String id) {
        String fullId = AbstractDNetOafXsltFunctions.oafSimpleId((String)type, (String)id);
        return OafRowKeyDecoder.decode((String)fullId).getKey();
    }

    private String getResolvedId(String originalId, List<Column> columns) {
        if (StringUtils.isBlank((String)originalId)) {
            throw new IllegalArgumentException("cannot resolve an empty id");
        }
        for (Column c : columns) {
            if (!c.getFamily().contains("isMergedIn")) continue;
            for (String s : c.getQualifier()) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                return s;
            }
        }
        return originalId;
    }

    public String getBlacklistParamName() {
        return this.blacklistParamName;
    }

    public void setBlacklistParamName(String blacklistParamName) {
        this.blacklistParamName = blacklistParamName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

