/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.blacklist;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.hadoop.rmi.hbase.Column;
import eu.dnetlib.data.hadoop.rmi.hbase.HBaseRowDescriptor;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.blacklist.ResolvedBlacklistEntry;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ApplyBlacklistJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(ApplyBlacklistJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String blacklistParamName;
    private String clusterName;
    private String tableName;

    protected String execute(NodeToken token) throws Exception {
        String resolvedBlString = token.getEnv().getAttribute(this.getBlacklistParamName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("got resolved blacklist map: " + resolvedBlString));
        }
        Type typeToken = new TypeToken<List<ResolvedBlacklistEntry>>(){}.getType();
        List resolved = (List)new Gson().fromJson(resolvedBlString, typeToken);
        HashMap relCache = Maps.newHashMap();
        HadoopService hadoopService = (HadoopService)this.serviceLocator.getService(HadoopService.class);
        for (ResolvedBlacklistEntry rbe : resolved) {
            if (!relCache.containsKey(rbe.getRelType())) {
                relCache.put(rbe.getRelType(), this.fetchInverse(rbe.getRelType()));
            }
            hadoopService.deleteHBaseColumn(this.getClusterName(), this.getTableName(), this.getHBaseRowDescriptor(rbe.getSource(), rbe.getTarget(), rbe.getRelType()));
            hadoopService.deleteHBaseColumn(this.getClusterName(), this.getTableName(), this.getHBaseRowDescriptor(rbe.getTarget(), rbe.getSource(), (String)relCache.get(rbe.getRelType())));
        }
        return Arc.DEFAULT_ARC;
    }

    private String fetchInverse(String relType) throws ISLookUpException {
        String xquery = "let $x:= /RESOURCE_PROFILE[ .//RESOURCE_TYPE/@value = 'OntologyDSResourceType' and  .//TERM/@encoding='" + relType + "']" + "let $y:= $x//TERM[./@encoding='" + relType + "']//RELATION[./@type='inverseOf']/@code/string() " + "return $x//TERM[./@code = $y]/@encoding/string()";
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
    }

    private HBaseRowDescriptor getHBaseRowDescriptor(String source, String target, String relType) {
        ArrayList cols = Lists.newArrayList((Object[])new Column[]{new Column(relType, (List)Lists.newArrayList((Object[])new String[]{target}))});
        return new HBaseRowDescriptor(source, (List)cols);
    }

    public String getBlacklistParamName() {
        return this.blacklistParamName;
    }

    public void setBlacklistParamName(String blacklistParamName) {
        this.blacklistParamName = blacklistParamName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

