/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.blacklist;

import com.google.common.collect.Lists;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.openaire.blacklist.BlacklistEntry;
import eu.dnetlib.openaire.blacklist.BlacklistManager;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class BlacklistInternalController
extends AbstractAjaxController {
    private static final Log log = LogFactory.getLog(BlacklistInternalController.class);
    @Resource
    private BlacklistManager blacklistManager;

    @ResponseBody
    @RequestMapping(value={"/ui/blacklist/getBlacklist.do"})
    public List<BlacklistEntry> getBlacklist() {
        log.debug((Object)"getBlacklist");
        return Lists.newArrayList(this.blacklistManager.getBlacklist());
    }

    @ResponseBody
    @RequestMapping(value={"/ui/blacklist/addToBlacklist.do"})
    public boolean addToBlacklist(@RequestBody(required=true) BlacklistEntry entry) throws Exception {
        log.debug((Object)"addToBlacklist");
        return this.blacklistManager.addToBlacklist(entry);
    }

    @ResponseBody
    @RequestMapping(value={"/ui/blacklist/editBlacklistEntry.do"})
    public boolean editBlacklistEntry(@RequestBody(required=true) BlacklistEntry entry) throws Exception {
        log.debug((Object)("editing blacklist entry " + entry.getId()));
        return this.blacklistManager.editBlacklistEntry(entry);
    }

    @ResponseBody
    @RequestMapping(value={"/ui/blacklist/deleteFromBlacklist.do"})
    public boolean deleteFromBlacklist(@RequestBody(required=true) int entryId) throws Exception {
        log.debug((Object)("deleting blacklist entry " + entryId));
        return this.blacklistManager.deleteFromBlacklist(entryId);
    }

    @ResponseBody
    @RequestMapping(value={"/ui/blacklist/getListOfRelationships.do"})
    public Set<String> getListOfRelationships() throws Exception {
        return this.blacklistManager.getListOfRelationships();
    }
}

