var blacklistControllers = angular.module('blacklistControllers', []);

function common_init($scope, $http, $sce, $location) {
    initSpinner();
    $scope.showError = function (error) {
        show_notification("error", error);
    };
    $scope.showNotification = function (message) {
        show_notification("info", message);
    };
    $scope.showSpinner = function () {
        showSpinner();
    };
    $scope.hideSpinner = function () {
        hideSpinner();
    };
    $scope.to_trusted = function (html) {
        return $sce.trustAsHtml(html);
    };
    $scope.go = function (path) {
        $location.path(path);
    };
    $scope.encodeValue = function (val) {
        return val;
    };

}

blacklistControllers.controller('blacklistCtrl', [
    '$scope', '$http', '$sce', '$location', function ($scope, $http, $sce, $location) {
        common_init($scope, $http, $sce, $location);

        $scope.blacklist = [];
		$scope.relationTypes = [];

        $scope.getBlacklist = function () {
            $scope.blacklist = [];

            $scope.showSpinner();

            $http.get('blacklist/getBlacklist.do').success(function (data) {
                $scope.hideSpinner();
                $scope.blacklist = data;
            }).error(function () {
	            $scope.showError('Problems getting the blacklist');
                $scope.hideSpinner();
            });
        };

        $scope.getBlacklist();

		$scope.addToBlacklist = function (newEntry) {
            $('.modal').modal('hide');
            $scope.showSpinner();
            $http.post('blacklist/addToBlacklist.do', newEntry).success(function (data) {
                if (data === 'false') {
                    $scope.showError('Cannot add blacklist entry: probably it is a duplicate')
                }
                else {
                    $scope.showNotification('Blacklist entry successfully added');
                    $scope.getBlacklist();
                }
            }).error(function () {
                $scope.showError('ERROR: cannot add blacklist entry');
            });
            $scope.hideSpinner();
            $scope.entry = [];
			$scope.newEntry = [];
        };

        $scope.prepareForEdit = function (entry) {
            $scope.entryToEdit = entry;
            $('#editBlacklistEntryModal').modal('show');
        };


        $scope.editBlacklistEntry = function (entry) {
            $('.modal').modal('hide');
            $scope.showSpinner();
            $http.post('blacklist/editBlacklistEntry.do', entry).success(function (data) {
                if (data === 'false') {
                    $scope.showError('Cannot edit entry')
                }
                else $scope.showNotification('Blacklist entry successfully edited');
            }).error(function () {
                $scope.showError('ERROR: cannot edit blacklist entry');
            });
            $scope.hideSpinner();
            $scope.entryToEdit = [];
        };

        $scope.deleteFromBlacklist = function (id) {
            var result = confirm("Are you sure you want to delete it?");
            if (result) {
                $scope.showSpinner();
                $http.post('blacklist/deleteFromBlacklist.do', id).success(function (data) {
                    if (data === 'false') {
                        $scope.showError('Cannot delete entry')
                    }
                    else {
                        $scope.showNotification('Blacklist entry successfully deleted');
                        $scope.getBlacklist();
                    }

                }).error(function () {
                    $scope.showError('ERROR: cannot delete blacklist entry');
                });
                $scope.hideSpinner();
                $scope.entry = [];
            }
        };


    }
]);
