var module = angular.module('blacklist', ['ngRoute', 'blacklistControllers']);

module.config([
    '$routeProvider',
    function ($routeProvider) {
        $routeProvider
            .when('/blacklist', {
                templateUrl: '../resources/html/blacklist/blacklist.html',
                controller: 'blacklistCtrl'
            })
            .otherwise({redirectTo: '/blacklist'});
    }
]);

module.directive('ngBlacklistForm', function () {
    return {
        restrict: 'E',
        templateUrl: '../resources/html/blacklist/blacklistEntryForm.html',
        scope: {entry: "="},
	    controller: function ($scope, $filter, $http) {

            $scope.entityTypes = ['result', 'project', 'datasource', 'organization', 'person'];
		    $scope.relationTypes = [];

            $scope.removeOriginalSourceId = function (id) {
                $scope.entry.originalSourceObjects = $filter('filter')($scope.entry.originalSourceObjects, '!' + id);
            };

            $scope.removeOriginalTargetId = function (id) {
                $scope.entry.originalTargetObjects = $filter('filter')($scope.entry.originalTargetObjects, '!' + id);
            };

            $scope.addSourceId = function (id) {
                if ($scope.entry.originalSourceObjects == undefined) $scope.entry.originalSourceObjects = [];
                $scope.entry.originalSourceObjects.push(id);
                $scope.newSourceId = null;
            };

            $scope.addTargetId = function (id) {
                if ($scope.entry.originalTargetObjects == undefined) $scope.entry.originalTargetObjects = [];
                $scope.entry.originalTargetObjects.push(id);
                $scope.newTargetId = null;
            };

		    $scope.getListOfRelationships = function () {
			    $http.get('blacklist/getListOfRelationships.do').success(function (data) {
				    $scope.relationTypes = data;
			    }).error(function () {
				    $scope.showError('Problems getting the list of relationships..');
			    });
		    };

		    $scope.getListOfRelationships();
        }
    };
});
