CREATE TYPE IIS_STATUS AS ENUM ('UNSOLVED', 'SOLVED');
CREATE TYPE STATUS AS ENUM ('PENDING', 'ACCEPTED', 'REFUSED', 'DELETED');

CREATE TABLE blacklist (
	id                      SERIAL,
	source_object           CHARACTER VARYING(255) NOT NULL,
	target_object           CHARACTER VARYING(255) NOT NULL,

	source_type             CHARACTER VARYING(255) NOT NULL,
	target_type             CHARACTER VARYING(255) NOT NULL,

	relationship            CHARACTER VARYING(255) NOT NULL,

	provenance              CHARACTER VARYING(255) NOT NULL,
	iis_module              CHARACTER VARYING(255),
	iis_module_profile      CHARACTER VARYING(255),

	iis_status              IIS_STATUS,
	status                  STATUS                 NOT NULL,

	original_source_objects CHARACTER VARYING(255) ARRAY,
	original_target_objects CHARACTER VARYING(255) ARRAY,

	creation_time           TIMESTAMP DEFAULT now(),
	last_update_time        TIMESTAMP DEFAULT now(),

	note                    TEXT,
	ticket_id               CHARACTER VARYING(255),
	userid                  CHARACTER VARYING(255) NOT NULL,

	PRIMARY KEY (source_object, target_object, relationship)

);

CREATE INDEX ON blacklist (source_object);
CREATE INDEX ON blacklist (target_object);
CREATE INDEX ON blacklist (ticket_id, original_source_objects, original_target_objects);
CREATE INDEX ON blacklist (iis_status);
CREATE INDEX ON blacklist (status);

--TRIGGER TO UPDATE THE last_update_time on UPDATES
CREATE OR REPLACE FUNCTION update_modified_column()
  RETURNS TRIGGER AS $$
BEGIN
  NEW.last_update_time = now();
  RETURN NEW;
END;
$$ LANGUAGE 'plpgsql';

CREATE TRIGGER update_blacklist_modtime BEFORE UPDATE ON blacklist FOR EACH ROW EXECUTE PROCEDURE update_modified_column();

-- Just for test

-- INSERT INTO blacklist (userid, relationship, provenance, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
-- VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'crosswalk',
--        'ACCEPTED', 'od________18::xxxxxxxxxxxxxxxxxx', 'result',
--        'corda_______::9826e8aba3e8f3a2a46545cf341838a8', 'project', '1');
-- INSERT INTO blacklist (userid, relationship, provenance, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
-- VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'crosswalk',
--         'PENDING', 'od________18::yyyyyyyyyyyyyyyyyyyy', 'result',
--         'corda_______::9826e8aba3e8f3a2a46545cf341838a8', 'project', '1');
-- INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
-- VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
--         'iis::document_referencedProjects',
--         'UNSOLVED', 'ACCEPTED', 'od______2367::eb76f733498920166d4ce77ec37d4X', 'result',
--         'corda_______::800e636c0a24ac3767701a789a96baX', 'project', '1360', '{"idsource::origi1", "idsource:orig2"}',
--         '{"idtarget::origi1", "idtarget:orig2","idtarget:orig3"}');

-- https://issue.openaire.research-infrastructures.eu/issues/1245
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects', 'UNSOLVED', 'ACCEPTED', 'od_______908::a47e1c3ede9a21ee5278a2e5c338d69b', 'result',
        'corda_______::fda6a1c19dac47508b6fb619518328c7', 'project', '1245', '{"od_______908::a47e1c3ede9a21ee5278a2e5c338d69b"}', '{"corda_______::fda6a1c19dac47508b6fb619518328c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects', 'UNSOLVED', 'ACCEPTED', 'od_______908::a47e1c3ede9a21ee5278a2e5c338d69b', 'result',
        'corda_______::189ff31d637eaaeaf4d3584dc490b1cf', 'project', '1245', '{"od_______908::a47e1c3ede9a21ee5278a2e5c338d69b"}', '{"corda_______::189ff31d637eaaeaf4d3584dc490b1cf"}');

-- https://issue.openaire.research-infrastructures.eu/issues/1360			
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects', 'UNSOLVED', 'ACCEPTED', 'od________18::a727cc288016db7132ef9a799aa83350', 'result',
        'corda_______::9826e8aba3e8f3a2a46545cf341838a8', 'project', '1360', '{"od________18::a727cc288016db7132ef9a799aa83350"}', '{"corda_______::9826e8aba3e8f3a2a46545cf341838a8"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects', 'UNSOLVED', 'ACCEPTED', 'od________18::062cf091d5c7a7d730001c34177042e3', 'result',
        'corda_______::9826e8aba3e8f3a2a46545cf341838a8', 'project', '1360', '{"od________18::062cf091d5c7a7d730001c34177042e3"}',
        '{"corda_______::9826e8aba3e8f3a2a46545cf341838a8"}');

-- https://issue.openaire.research-infrastructures.eu/issues/1254
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects', 'SOLVED',
        'ACCEPTED', 'webcrawl____::68c191d9b972b47a235d311804c7f6f5', 'result', 'corda_______::c3d0b21615b129cd7395e24f9cf6bb64', 'project',
        '1254', '{"webcrawl____::68c191d9b972b47a235d311804c7f6f5"}', '{"corda_______::c3d0b21615b129cd7395e24f9cf6bb64"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'od_______908::1b172ab34639e7935e2357119cf20830', 'result',
        'corda_______::c3d0b21615b129cd7395e24f9cf6bb64', 'project', '1254', '{"od_______908::1b172ab34639e7935e2357119cf20830"}',
        '{"corda_______::c3d0b21615b129cd7395e24f9cf6bb64"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'doajarticles::cb234c66327d29ba5f13c0db7a4cf423', 'result',
        'corda_______::c3d0b21615b129cd7395e24f9cf6bb64', 'project', '1254', '{"doajarticles::cb234c66327d29ba5f13c0db7a4cf423"}',
        '{"corda_______::c3d0b21615b129cd7395e24f9cf6bb64"}');

-- https://issue.openaire.research-infrastructures.eu/issues/1297
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects', 'UNSOLVED',
        'ACCEPTED', 'od______1146::e2fafaba636a14e408f02c6ea26acb0e', 'result', 'corda_______::35695c955c51f0bb39482ce5477047c7', 'project',
        '1297', '{"od______1146::e2fafaba636a14e408f02c6ea26acb0e"}', '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'od_______908::b8e86ed982ff331764456e1f0759ed9c', 'result',
        'corda_______::35695c955c51f0bb39482ce5477047c7', 'project', '1297', '{"od_______908::b8e86ed982ff331764456e1f0759ed9c"}',
        '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'webcrawl____::c472bf5944ce0495844d505d43d1c021', 'result',
        'corda_______::35695c955c51f0bb39482ce5477047c7', 'project', '1297', '{"webcrawl____::c472bf5944ce0495844d505d43d1c021"}',
        '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'od_______908::bbe86580e44dbefa401d435259baddf1', 'result',
        'corda_______::35695c955c51f0bb39482ce5477047c7', 'project', '1297', '{"od_______908::bbe86580e44dbefa401d435259baddf1"}',
        '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'webcrawl____::ae0ae3ea5641ac24fa148ac38397dfcd', 'result',
        'corda_______::35695c955c51f0bb39482ce5477047c7', 'project', '1297', '{"webcrawl____::ae0ae3ea5641ac24fa148ac38397dfcd"}',
        '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'webcrawl____::5f46a8c6420f5b5eaf30d7212b0ada5b', 'result',
        'corda_______::35695c955c51f0bb39482ce5477047c7', 'project', '1297', '{"webcrawl____::5f46a8c6420f5b5eaf30d7212b0ada5b"}',
        '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'od_______908::49d9b3df9cf7e9c991e09e53677e40e3', 'result',
        'corda_______::35695c955c51f0bb39482ce5477047c7', 'project', '1297', '{"od_______908::49d9b3df9cf7e9c991e09e53677e40e3"}',
        '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'od_______330::aa2edd06a6121a1a1db63be83cd7b7c7', 'result',
        'corda_______::35695c955c51f0bb39482ce5477047c7', 'project', '1297', '{"od_______330::aa2edd06a6121a1a1db63be83cd7b7c7"}',
        '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'od_______908::45f342e6f10d5543631a757b417388d7', 'result',
        'corda_______::35695c955c51f0bb39482ce5477047c7', 'project', '1297', '{"od_______908::45f342e6f10d5543631a757b417388d7"}',
        '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'webcrawl____::6ce2789da52c6036501533ed5613d71a', 'result',
        'corda_______::35695c955c51f0bb39482ce5477047c7', 'project', '1297', '{"webcrawl____::6ce2789da52c6036501533ed5613d71a"}',
        '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'webcrawl____::f887afc3d7a8e8c708b9b773d26cdd9d', 'result',
        'corda_______::35695c955c51f0bb39482ce5477047c7', 'project', '1297', '{"webcrawl____::f887afc3d7a8e8c708b9b773d26cdd9d"}',
        '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'webcrawl____::161ee67349e268750701ee437188340b', 'result',
        'corda_______::35695c955c51f0bb39482ce5477047c7', 'project', '1297', '{"webcrawl____::161ee67349e268750701ee437188340b"}',
        '{"corda_______::35695c955c51f0bb39482ce5477047c7"}');

-- https://issue.openaire.research-infrastructures.eu/issues/1412
INSERT INTO blacklist (userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects)
VALUES ('unknown', 'resultProject_outcome_isProducedBy', 'iis',
        'iis::document_referencedProjects',
        'UNSOLVED', 'ACCEPTED', 'od______2367::eb76f733498920166d4ce77ec37d487c', 'result',
        'corda_______::800e636c0a24ac3767701a789a96ba89', 'project', '1360', '{"od______2367::eb76f733498920166d4ce77ec37d487c"}',
        '{"corda_______::800e636c0a24ac3767701a789a96ba89"}');



