package eu.dnetlib.msro.workflows.blacklist;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.hadoop.rmi.hbase.Column;
import eu.dnetlib.data.hadoop.rmi.hbase.HBaseRowDescriptor;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by alessia on 23/10/15.
 */
public class ApplyBlacklistJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(ApplyBlacklistJobNode.class);

	@Autowired
    private UniqueServiceLocator serviceLocator;

    private String blacklistParamName;

	private String clusterName;
    private String tableName;

    @Override
    protected String execute(NodeToken token) throws Exception {

	    final String resolvedBlString = token.getEnv().getAttribute(getBlacklistParamName());
	    if (log.isDebugEnabled()) {
		    log.debug("got resolved blacklist map: " + resolvedBlString);
	    }
	    final Type typeToken = new TypeToken<List<ResolvedBlacklistEntry>>() {}.getType();
	    final List<ResolvedBlacklistEntry> resolved =  new Gson().fromJson(resolvedBlString, typeToken);

	    final Map<String, String> relCache = Maps.newHashMap();

	    final HadoopService hadoopService = serviceLocator.getService(HadoopService.class);

	    for(ResolvedBlacklistEntry rbe : resolved) {

		    if (!relCache.containsKey(rbe.getRelType())) {
			    relCache.put(rbe.getRelType(), fetchInverse(rbe.getRelType()));
		    }

		    hadoopService.deleteHBaseColumn(getClusterName(), getTableName(), getHBaseRowDescriptor(rbe.getSource(), rbe.getTarget(), rbe.getRelType()));

		    hadoopService.deleteHBaseColumn(getClusterName(), getTableName(), getHBaseRowDescriptor(rbe.getTarget(), rbe.getSource(), relCache.get(
				    rbe.getRelType())));
	    }

        return Arc.DEFAULT_ARC;
    }

	private String fetchInverse(final String relType) throws ISLookUpException {
		final String xquery = "let $x:= /RESOURCE_PROFILE["
				+ " .//RESOURCE_TYPE/@value = 'OntologyDSResourceType' and "
				+ " .//TERM/@encoding='"+relType+"']"
				+ "let $y:= $x//TERM[./@encoding='"+relType+"']//RELATION[./@type='inverseOf']/@code/string() "
				+ "return $x//TERM[./@code = $y]/@encoding/string()";
		return serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xquery);
	}

	private HBaseRowDescriptor getHBaseRowDescriptor(final String source, final String target, final String relType) {

		final List<Column> cols = Lists.newArrayList(new Column(relType, Lists.newArrayList(target)));
		return new HBaseRowDescriptor(source, cols);
	}

    public String getBlacklistParamName() {
        return blacklistParamName;
    }

    public void setBlacklistParamName(String blacklistParamName) {
        this.blacklistParamName = blacklistParamName;
    }

	public String getClusterName() {
		return clusterName;
	}

	public void setClusterName(final String clusterName) {
		this.clusterName = clusterName;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(final String tableName) {
		this.tableName = tableName;
	}

}
