package eu.dnetlib.data.information.oai.publisher.info;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

import com.google.common.collect.Lists;

import eu.dnetlib.data.information.oai.publisher.BadResumptionTokenException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;

public class ResumptionTokenImpl implements ResumptionToken {

	/**
	 * Total number of documents.
	 */
	private int nMaxElements;
	/**
	 * Requested metadata prefix.
	 */
	private String metadataPrefix;
	/**
	 * Query to use generate the requested records.
	 */
	private String query;

	/**
	 * Number of already read records.
	 */
	private int nRead;

	/**
	 * objIdentifier of the last read document.
	 */
	private String lastObjIdentifier;

	/**
	 * Requested set. Optional.
	 */
	private String requestedSet = "";

	private boolean hasDateRange = false;

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#serialize()
	 */
	@Override
	public String serialize() {
		String escapedQuery = StringEscapeUtils.escapeXml(query);
		List<String> info = Lists.newArrayList("" + nMaxElements, metadataPrefix, escapedQuery, "" + nRead, lastObjIdentifier, "" + hasDateRange, requestedSet);
		try {
			String encoded = URLEncoder.encode(StringUtils.join(info, "|"), "UTF-8");
			return encoded;
		} catch (UnsupportedEncodingException e) {
			throw new OaiPublisherRuntimeException(e);
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @throws BadResumptionTokenException
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#deserialize(java.lang.String)
	 */
	@Override
	public void deserialize(final String token) throws BadResumptionTokenException {
		String decoded;
		try {
			decoded = URLDecoder.decode(token, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new OaiPublisherRuntimeException(e);
		}
		String[] info = StringUtils.split(decoded, "|");
		if (info.length < 6) throw new BadResumptionTokenException(token);
		this.nMaxElements = Integer.parseInt(info[0]);
		this.metadataPrefix = info[1];
		String unescapedQuery = StringEscapeUtils.unescapeXml(info[2]);
		this.query = unescapedQuery;
		this.nRead = Integer.parseInt(info[3]);
		this.lastObjIdentifier = info[4];
		this.hasDateRange = Boolean.valueOf(info[5]);
		if (info.length == 7) {
			this.requestedSet = info[6];
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getnMaxElements()
	 */
	@Override
	public int getnMaxElements() {
		return nMaxElements;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setnMaxElements(int)
	 */
	@Override
	public void setnMaxElements(final int nMaxElements) {
		this.nMaxElements = nMaxElements;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getMetadataPrefix()
	 */
	@Override
	public String getMetadataPrefix() {
		return metadataPrefix;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setMetadataPrefix(java.lang.String)
	 */
	@Override
	public void setMetadataPrefix(final String metadataPrefix) {
		this.metadataPrefix = metadataPrefix;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getQuery()
	 */
	@Override
	public String getQuery() {
		return query;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setQuery(java.lang.String)
	 */
	@Override
	public void setQuery(final String query) {
		this.query = query;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getnRead()
	 */
	@Override
	public int getnRead() {
		return nRead;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setnRead(int)
	 */
	@Override
	public void setnRead(final int nRead) {
		this.nRead = nRead;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getLastObjIdentifier()
	 */
	@Override
	public String getLastObjIdentifier() {
		return lastObjIdentifier;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setLastObjIdentifier(java.lang.String)
	 */
	@Override
	public void setLastObjIdentifier(final String lastObjIdentifier) {
		this.lastObjIdentifier = lastObjIdentifier;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getRequestedSet()
	 */
	@Override
	public String getRequestedSet() {
		return requestedSet;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setRequestedSet(java.lang.String)
	 */
	@Override
	public void setRequestedSet(final String requestedSet) {
		this.requestedSet = requestedSet;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#hasDateRange()
	 */
	@Override
	public boolean hasDateRange() {
		return this.hasDateRange;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setDateRange(boolean)
	 */
	@Override
	public void setDateRange(final boolean hasDateRange) {
		this.hasDateRange = hasDateRange;
	}

	@Override
	public String toString() {
		return "ResumptionTokenImpl [nMaxElements=" + nMaxElements + ", metadataPrefix=" + metadataPrefix + ", query=" + query + ", nRead=" + nRead
				+ ", lastObjIdentifier=" + lastObjIdentifier + ", hasDateRange=" + hasDateRange + ", requestedSet=" + requestedSet + "]";
	}

}
