package eu.dnetlib.data.information.oai.publisher.conf;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;

import eu.dnetlib.data.information.oai.publisher.PublisherField;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;

/**
 * An instance of this class represents an OAI Configuration profile.
 * 
 * @author alessia
 * 
 */
public class OAIConfiguration {

	/**
	 * Map for OAI sets. Keys: setSpec, values: SetInfo instances.
	 */
	private Map<String, SetInfo> setsMap;

	/**
	 * Map for metadata formats. Keys: metadata prefix, values: MDFInfo instances.
	 */
	private Map<String, MDFInfo> mdFormatsMap;

	private List<PublisherField> fields;

	private List<String> fieldNames;

	/**
	 * Used to generate the OAI identifiers compliant to the protocol. See
	 * http://www.openarchives.org/OAI/openarchivesprotocol.html#UniqueIdentifier. See property services.oai.publisher.id.scheme.
	 */
	private String idScheme;
	/**
	 * Used to generate the OAI identifiers compliant to the protocol. See
	 * http://www.openarchives.org/OAI/openarchivesprotocol.html#UniqueIdentifier. See property services.oai.publisher.id.namespace.
	 */
	private String idNamespace;

	private Set<MDFInfo> sourcesMDF = Sets.newHashSet();

	public Collection<PublisherField> getFieldsFor(final String format, final String layout, final String interpretation) {
		final String mdRef = Joiner.on("-").join(format, layout, interpretation);
		return Collections2.filter(this.getFields(), new Predicate<PublisherField>() {

			@Override
			public boolean apply(final PublisherField theField) {
				if (theField.getSources() == null) return false;
				return theField.getSources().containsKey(mdRef);
			}

		});
	}

	public Map<String, SetInfo> getSetsMap() {
		return setsMap;
	}

	public void setSetsMap(final Map<String, SetInfo> setsMap) {
		this.setsMap = setsMap;
	}

	public Map<String, MDFInfo> getMdFormatsMap() {
		return mdFormatsMap;
	}

	public void setMdFormatsMap(final Map<String, MDFInfo> mdFormatsMap) {
		this.mdFormatsMap = mdFormatsMap;
	}

	public List<PublisherField> getFields() {
		return fields;
	}

	public void setFields(final List<PublisherField> fields) {
		this.fields = fields;
	}

	public List<String> getFieldNames() {
		return fieldNames;
	}

	public void setFieldNames(final List<String> fieldNames) {
		this.fieldNames = fieldNames;
	}

	public Set<MDFInfo> getSourcesMDF() {
		return sourcesMDF;
	}

	public void setSourcesMDF(final Set<MDFInfo> sourcesMDF) {
		this.sourcesMDF = sourcesMDF;
	}

	public String getIdScheme() {
		return idScheme;
	}

	public void setIdScheme(final String idScheme) {
		this.idScheme = idScheme;
	}

	public String getIdNamespace() {
		return idNamespace;
	}

	public void setIdNamespace(final String idNamespace) {
		this.idNamespace = idNamespace;
	}

}
