/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.PublisherField;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfiguration;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAIConfigurationParser {
    private static final Log log = LogFactory.getLog(OAIConfigurationParser.class);
    private final ThreadLocal<XMLInputFactory> factory = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XMLInputFactory.newInstance();
        }
    };

    public OAIConfiguration getConfiguration(String configurationProfile) throws IOException {
        log.debug((Object)configurationProfile);
        OAIConfiguration config = new OAIConfiguration();
        HashMap setsMap = Maps.newHashMap();
        HashMap mdFormatsMap = Maps.newHashMap();
        ArrayList indexNames = Lists.newArrayList();
        ArrayList fields = Lists.newArrayList();
        try {
            XMLStreamReader parser = this.factory.get().createXMLStreamReader(new StreamSource(new StringReader(configurationProfile)));
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                String localName = parser.getLocalName();
                if (localName.equals("IDSCHEME")) {
                    config.setIdScheme(parser.getElementText());
                    continue;
                }
                if (localName.equals("IDNAMESPACE")) {
                    config.setIdNamespace(parser.getElementText());
                    continue;
                }
                if (localName.equals("OAISET")) {
                    boolean inSet = true;
                    SetInfo setInfo = new SetInfo();
                    String enabled = parser.getAttributeValue(null, "enabled");
                    setInfo.setEnabled(Boolean.parseBoolean(enabled));
                    while (parser.hasNext() && inSet) {
                        event = parser.next();
                        if (event == 1) {
                            String setElementName = parser.getLocalName();
                            String setElementValue = parser.getElementText();
                            this.handleSetInfo(setInfo, setElementName, setElementValue);
                        }
                        if (event != 2 || !parser.getLocalName().equals("OAISET")) continue;
                        inSet = false;
                        setsMap.put(setInfo.getSetSpec(), setInfo);
                    }
                    continue;
                }
                if (localName.equals("METADATAFORMAT")) {
                    boolean inMetadata = true;
                    MDFInfo mdfInfo = new MDFInfo();
                    String exportable = parser.getAttributeValue(null, "exportable");
                    mdfInfo.setEnabled(Boolean.parseBoolean(exportable));
                    String mdPrefix = parser.getAttributeValue(null, "metadataPrefix");
                    mdfInfo.setPrefix(mdPrefix);
                    while (parser.hasNext() && inMetadata) {
                        event = parser.next();
                        if (event == 1) {
                            String mdfElementName = parser.getLocalName();
                            if (mdfElementName.equals("SOURCE_METADATA_FORMAT")) {
                                this.handleSourceMDF(mdfInfo, parser);
                                config.getSourcesMDF().add(mdfInfo);
                            } else {
                                String mdfElementValue = parser.getElementText();
                                this.handleMDFInfo(mdfInfo, mdfElementName, mdfElementValue);
                            }
                        }
                        if (event != 2 || !parser.getLocalName().equals("METADATAFORMAT")) continue;
                        inMetadata = false;
                        mdFormatsMap.put(mdPrefix, mdfInfo);
                    }
                    continue;
                }
                if (!localName.equals("INDEX")) continue;
                boolean inIndex = true;
                PublisherField publisherField = new PublisherField();
                String indexName = parser.getAttributeValue(null, "name");
                String repeatable = parser.getAttributeValue(null, "repeatable");
                boolean isRepeatable = Boolean.valueOf(repeatable);
                indexNames.add(indexName);
                publisherField.setFieldName(indexName);
                publisherField.setRepeatable(isRepeatable);
                ArrayListMultimap fieldSources = ArrayListMultimap.create();
                while (parser.hasNext() && inIndex) {
                    event = parser.next();
                    if (event == 1) {
                        String currentElementName = parser.getLocalName();
                        this.handleIndex((Multimap<String, String>)fieldSources, indexName, parser, currentElementName);
                    }
                    if (event != 2 || !parser.getLocalName().equals("INDEX")) continue;
                    inIndex = false;
                }
                publisherField.setSources((Multimap<String, String>)fieldSources);
                fields.add(publisherField);
            }
            config.setFields(fields);
            config.setFieldNames(indexNames);
            config.setMdFormatsMap(mdFormatsMap);
            config.setSetsMap(setsMap);
            return config;
        }
        catch (XMLStreamException e) {
            throw new OaiPublisherRuntimeException(e);
        }
    }

    private void handleIndex(Multimap<String, String> fieldSources, String indexName, XMLStreamReader parser, String currentLocalName) {
        if (currentLocalName.equals("SOURCE")) {
            MDFInfo indexSource = new MDFInfo();
            this.handleSourceMDF(indexSource, parser);
            String key = indexSource.getSourceFormatName() + "-" + indexSource.getSourceFormatLayout() + "-" + indexSource.getSourceFormatInterpretation();
            fieldSources.put((Object)key, (Object)parser.getAttributeValue(null, "path"));
        } else {
            log.warn((Object)("I do not know how to handle INDEX element with name " + currentLocalName));
        }
    }

    private void handleSourceMDF(MDFInfo mdfInfo, XMLStreamReader parser) {
        String interpretation = parser.getAttributeValue(null, "interpretation");
        String layout = parser.getAttributeValue(null, "layout");
        String name = parser.getAttributeValue(null, "name");
        mdfInfo.setSourceFormatInterpretation(interpretation);
        mdfInfo.setSourceFormatLayout(layout);
        mdfInfo.setSourceFormatName(name);
    }

    private void handleMDFInfo(MDFInfo mdfInfo, String elementName, String elementValue) {
        if (elementName.equals("NAMESPACE")) {
            mdfInfo.setNamespace(elementValue);
        } else if (elementName.equals("SCHEMA")) {
            mdfInfo.setSchema(elementValue);
        } else if (elementName.equals("TRANSFORMATION_RULE")) {
            mdfInfo.setTransformationRuleID(elementValue);
        } else if (elementName.equals("BASE_QUERY")) {
            mdfInfo.setBaseQuery(elementValue);
        } else {
            log.warn((Object)("I do not know how to handle Metadata Format element with name " + elementName + " and value " + elementValue));
        }
    }

    private void handleSetInfo(SetInfo setInfo, String elementName, String elementValue) {
        if (elementName.equals("spec")) {
            setInfo.setSetSpec(elementValue);
        } else if (elementName.equals("name")) {
            setInfo.setSetName(elementValue);
        } else if (elementName.equals("description")) {
            setInfo.setSetDescription(elementValue);
        } else if (elementName.equals("query")) {
            setInfo.setQuery(elementValue);
        } else {
            log.warn((Object)("I do not know how to handle Set element with name " + elementName + " and value " + elementValue));
        }
    }
}

