package eu.dnetlib.data.information.oai.publisher.conf;

import java.util.List;

import eu.dnetlib.data.information.oai.publisher.PublisherField;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;

public interface OAIConfigurationReader {

	/**
	 * Constant names of fields used by the publisher to store records in the OAIStores. If you want an index over them, you need to specify
	 * it in the OAI Publisher Configuration profile.
	 */
	public final static String ID_FIELD = "objIdentifier";
	public final static String DATESTAMP_FIELD = "datestamp";
	public final static String SET_FIELD = "set";
	public final static String DELETED_FIELD = "deleted";
	public final static String BODY_FIELD = "body";
	public final static String UPDATED_FIELD = "updated";
	public final static String LAST_COLLECTION_DATE_FIELD = "lastCollectionDate";

	public List<SetInfo> getSets();

	public List<SetInfo> getSets(final boolean onlyEnabled);

	public List<String> getSetSpecs();

	public List<String> getSetSpecs(final boolean onlyEnabled);

	public SetInfo getSetInfo(final String setSpec);

	public List<MDFInfo> getMetadataFormatInfo();

	public List<MDFInfo> getMetadataFormatInfo(final boolean onlyEnabled);

	public MDFInfo getMetadataFormatInfo(final String mdPrefix);

	public List<String> getFieldNames();

	public List<PublisherField> getFields();

	public List<PublisherField> getFields(final String format, final String interpretation, final String layout);

	public String getIdScheme();

	public void setIdScheme(final String idScheme);

	public String getIdNamespace();

	public void setIdNamespace(final String idNamespace);

	public List<MDFInfo> getSourceMetadataFormats();

}
