package eu.dnetlib.data.oai.store.mongo;

import org.dom4j.Document;
import org.dom4j.Node;

import eu.dnetlib.miscutils.functional.UnaryFunction;

/**
 * Function to deliver only the about/provenance content of a record as XML String.
 */
public class ProvenanceExtractor implements UnaryFunction<String, Document> {

	@Override
	public String evaluate(final Document xmlDoc) {
		Node metadataNode = xmlDoc.selectSingleNode("//*[local-name() = 'about']/*[local-name() = 'provenance']");
		if (metadataNode != null) return metadataNode.asXML();
		else return null;
	}
}
