package eu.dnetlib.data.oai.store.actions;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class EnsureIndexesAction extends AbstractOAIStoreAction {

	private static final Log log = LogFactory.getLog(EnsureIndexesAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		try {
			String storeId = job.getParameters().get("collection");
			String dbName = job.getParameters().get("oai_dbName");
			if (StringUtils.isBlank(storeId)) {
				log.info("Ensuring index on all OAI store");
				this.mongoPublisherStoreDAO.ensureIndex(dbName);
			} else {
				log.info("Ensuring index on " + storeId + " only");
				MongoPublisherStore store = this.mongoPublisherStoreDAO.getStore(storeId, dbName);
				store.ensureIndices();
			}
			handler.done(job);
		} catch (Exception e) {
			handler.failed(job, e);
		}
	}

	public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
		return mongoPublisherStoreDAO;
	}

	public void setMongoPublisherStoreDAO(final MongoPublisherStoreDAO mongoPublisherStoreDAO) {
		this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
	}

}
