package eu.dnetlib.data.oai.store;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.conf.OAISetHelper;
import eu.dnetlib.data.oai.store.conf.OAISetsCounter;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.data.oai.store.sync.OAIStoreSynchronizer;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;

public class OAIStoreServiceImpl extends AbstractBaseService implements OAIStoreService {

	/**
	 * notification handler.
	 */
	private NotificationHandler notificationHandler;

	@Resource
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;
	@Resource
	private OAIStoreSynchronizer synchronizer;
	@Resource(name = "oaiSetsCounter")
	private OAISetsCounter setsCounter;
	@Autowired
	private OAISetHelper oaiSetHelper;

	@Resource
	private ResultSetClientFactory resultSetClientFactory;

	@Override
	public void feed(final W3CEndpointReference recordsEpr, final MDFInfo mdfInfo, final String dbName) {
		this.feed(recordsEpr, mdfInfo, "", dbName);
	}

	@Override
	public void feed(final W3CEndpointReference recordsEpr, final MDFInfo mdfInfo, final String recordSource, final String dbName) {
		IterableResultSetClient rsClient = resultSetClientFactory.getClient(recordsEpr);
		this.synchronizer.synchronize(rsClient, mdfInfo, recordSource, dbName, false, null, null);
	}

	@Override
	public void updateSetCounts(final String dbName) {
		this.setsCounter.updateCounts("", dbName, null, null);
	}

	@Override
	public void updateSetCounts(final MDFInfo mdfInfo, final String dbName) {
		this.setsCounter.updateCounts(mdfInfo, dbName, null, null);
	}

	@Override
	public void refreshConfiguration(final String dbName) {
		oaiSetHelper.loadConfiguration(dbName);
	}

	@Override
	public void ensureIndexes(final String dbName) {
		this.mongoPublisherStoreDAO.ensureIndex(dbName);
	}

	@Override
	public void ensureIndexes(final MDFInfo mdfInfo, final String dbName) {
		MongoPublisherStore s = this.mongoPublisherStoreDAO.getStore(mdfInfo.getSourceFormatName(), mdfInfo.getSourceFormatInterpretation(),
				mdfInfo.getSourceFormatLayout(), dbName);
		s.ensureIndices();
	}

	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		getNotificationHandler().notified(subscriptionId, topic, isId, message);
	}

	public NotificationHandler getNotificationHandler() {
		return notificationHandler;
	}

	@Required
	public void setNotificationHandler(final NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

	public OAIStoreSynchronizer getSynchronizer() {
		return synchronizer;
	}

	public void setSynchronizer(final OAIStoreSynchronizer synchronizer) {
		this.synchronizer = synchronizer;
	}

	public OAISetsCounter getSetsCounter() {
		return setsCounter;
	}

	public void setSetsCounter(final OAISetsCounter setsCounter) {
		this.setsCounter = setsCounter;
	}

	public OAISetHelper getOaiSetHelper() {
		return oaiSetHelper;
	}

	public void setOaiSetHelper(final OAISetHelper oaiSetHelper) {
		this.oaiSetHelper = oaiSetHelper;
	}

	public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
		return mongoPublisherStoreDAO;
	}

	public void setMongoPublisherStoreDAO(final MongoPublisherStoreDAO mongoPublisherStoreDAO) {
		this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
	}

	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	public void setResultSetClientFactory(final ResultSetClientFactory resultSetClientFactory) {
		this.resultSetClientFactory = resultSetClientFactory;
	}

}
