/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.oai.workflows.nodes.AbstractOAIJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class SyncOAIStoreJobNode
extends AbstractOAIJobNode
implements ProgressJobNode {
    private static final Log log = LogFactory.getLog(SyncOAIStoreJobNode.class);
    private String eprParam;
    private ProcessCountingResultSetFactory processCountingResultSetFactory;
    private ResultsetProgressProvider progressProvider;
    private String formatParam;
    private String layoutParam;
    private String interpretationParam;
    private String oai_dbName;
    private boolean alwaysNewRecord = false;

    @Override
    void completePrepareJob(BlackboardJob job, NodeToken token) throws ResultSetException {
        String eprS = token.getEnv().getAttribute(this.getEprParam());
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), eprS);
        job.setAction("SYNC");
        job.getParameters().put("oai_syncEpr", this.progressProvider.getEpr().toString());
        job.getParameters().put("oai_recordSource", token.getEnv().getAttribute("oai_recordSource"));
        job.getParameters().put("oai_formatName", token.getEnv().getAttribute(this.formatParam));
        job.getParameters().put("oai_formatLayout", token.getEnv().getAttribute(this.layoutParam));
        job.getParameters().put("oai_formatInterpretation", token.getEnv().getAttribute(this.interpretationParam));
        job.getParameters().put("oai_dbName", this.getOai_dbName());
        job.getParameters().put("oai_alwaysNewRecord", String.valueOf(this.alwaysNewRecord));
        token.getEnv().setAttribute("oai_dbName", this.getOai_dbName());
        log.fatal((Object)"Job prepared");
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
        return this.processCountingResultSetFactory;
    }

    @Required
    public void setProcessCountingResultSetFactory(ProcessCountingResultSetFactory processCountingResultSetFactory) {
        this.processCountingResultSetFactory = processCountingResultSetFactory;
    }

    public String getFormatParam() {
        return this.formatParam;
    }

    public void setFormatParam(String formatParam) {
        this.formatParam = formatParam;
    }

    public String getLayoutParam() {
        return this.layoutParam;
    }

    public void setLayoutParam(String layoutParam) {
        this.layoutParam = layoutParam;
    }

    public String getInterpretationParam() {
        return this.interpretationParam;
    }

    public void setInterpretationParam(String interpretationParam) {
        this.interpretationParam = interpretationParam;
    }

    public String getOai_dbName() {
        return this.oai_dbName;
    }

    public void setOai_dbName(String oai_dbName) {
        this.oai_dbName = oai_dbName;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public boolean isAlwaysNewRecord() {
        return this.alwaysNewRecord;
    }

    public void setAlwaysNewRecord(boolean alwaysNewRecord) {
        this.alwaysNewRecord = alwaysNewRecord;
    }
}

