package eu.dnetlib.msro.oai.workflows.nodes;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;

public class SyncOAIStoreJobNode extends AbstractOAIJobNode implements ProgressJobNode {

	private static final Log log = LogFactory.getLog(SyncOAIStoreJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String eprParam;

	private ProcessCountingResultSetFactory processCountingResultSetFactory;
	
	private ResultsetProgressProvider progressProvider;

	private String formatParam, layoutParam, interpretationParam, oai_dbName;
	
	private boolean alwaysNewRecord = false;

	@Override
	void completePrepareJob(final BlackboardJob job, final NodeToken token) throws ResultSetException {

		final String eprS = token.getEnv().getAttribute(getEprParam());
		this.progressProvider = processCountingResultSetFactory.createProgressProvider(token.getProcess(), eprS);
		job.setAction("SYNC");
		job.getParameters().put("oai_syncEpr", progressProvider.getEpr().toString());
		job.getParameters().put("oai_recordSource", token.getEnv().getAttribute("oai_recordSource"));
		job.getParameters().put("oai_formatName", token.getEnv().getAttribute(formatParam));
		job.getParameters().put("oai_formatLayout", token.getEnv().getAttribute(layoutParam));
		job.getParameters().put("oai_formatInterpretation", token.getEnv().getAttribute(interpretationParam));
		job.getParameters().put("oai_dbName", getOai_dbName());		
		job.getParameters().put("oai_alwaysNewRecord", String.valueOf(alwaysNewRecord));
		token.getEnv().setAttribute("oai_dbName", getOai_dbName());
		log.fatal("Job prepared");

	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
		return processCountingResultSetFactory;
	}

	@Required
	public void setProcessCountingResultSetFactory(final ProcessCountingResultSetFactory processCountingResultSetFactory) {
		this.processCountingResultSetFactory = processCountingResultSetFactory;
	}

	public String getFormatParam() {
		return formatParam;
	}

	public void setFormatParam(final String formatParam) {
		this.formatParam = formatParam;
	}

	public String getLayoutParam() {
		return layoutParam;
	}

	public void setLayoutParam(final String layoutParam) {
		this.layoutParam = layoutParam;
	}

	public String getInterpretationParam() {
		return interpretationParam;
	}

	public void setInterpretationParam(final String interpretationParam) {
		this.interpretationParam = interpretationParam;
	}

	public String getOai_dbName() {
		return oai_dbName;
	}

	public void setOai_dbName(final String oai_dbName) {
		this.oai_dbName = oai_dbName;
	}

	@Override
	public ProgressProvider getProgressProvider() {
		return this.progressProvider;
	}

	public boolean isAlwaysNewRecord() {
		return alwaysNewRecord;
	}

	public void setAlwaysNewRecord(boolean alwaysNewRecord) {
		this.alwaysNewRecord = alwaysNewRecord;
	}

}
