package eu.dnetlib.msro.oai.workflows.nodes;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

/**
 * The Class PrepareOaiDataJobNode.
 */
public class SetCurrentOAIDBJobNode extends SimpleJobNode {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(SetCurrentOAIDBJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/** The service locator. */
	@Resource
	private UniqueServiceLocator serviceLocator;

	/** Target mongo database name. **/
	private String oaiDBName;
	/** Name of the env property where to put the value of oaiDBName. **/
	private String oaiDBNameParam;

	private String xpathToCurrentDB = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION/CURRENTDB";

	protected String getTheDBName(final NodeToken token) {
		if (StringUtils.isNotBlank(oaiDBName)) {
			return oaiDBName;
		} else {
			return token.getEnv().getAttribute(oaiDBNameParam);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final NodeToken token) throws Exception {
		String dbToSet = getTheDBName(token);
		log.fatal("Setting OAI Publisher to use db " + dbToSet);
		String xUpdate = "update value " + xpathToCurrentDB + " with '" + dbToSet + "'";
		this.serviceLocator.getService(ISRegistryService.class).executeXUpdate(xUpdate);
		return Arc.DEFAULT_ARC;
	}

	public String getOaiDBName() {
		return oaiDBName;
	}

	public void setOaiDBName(final String oaiDBName) {
		this.oaiDBName = oaiDBName;
	}

	public String getOaiDBNameParam() {
		return oaiDBNameParam;
	}

	public void setOaiDBNameParam(final String oaiDBNameParam) {
		this.oaiDBNameParam = oaiDBNameParam;
	}

	public String getXpathToCurrentDB() {
		return xpathToCurrentDB;
	}

	public void setXpathToCurrentDB(final String xpathToCurrentDB) {
		this.xpathToCurrentDB = xpathToCurrentDB;

	}
}
