package eu.dnetlib.msro.oai.workflows.nodes;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class ReadMDStoreJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(ReadMDStoreJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * Name of the env attribute where the output epr will be saved.
	 */
	private String eprParam;

	// info about the metadata format of the records I'm reading
	private String mdFormatName;
	private String mdFormatLayout;
	private String mdFormatInterpretation;

	/** Name of the datasource whose records I am reading **/
	private String datasource;

	/**
	 * Identifier of the input mdstore.
	 */
	private String mdstoreId;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		/*
		 * public W3CEndpointReference deliverMDRecords( String mdId, String from, String until, String recordFilter) throws
		 * MDStoreServiceException;
		 */
		W3CEndpointReference epr = serviceLocator.getService(MDStoreService.class, mdstoreId).deliverMDRecords(mdstoreId, null, null, null);
		log.debug("Created W3CEndpointReference to read from mdstoreId = " + mdstoreId);
		token.getEnv().setAttribute(eprParam, epr.toString());
		token.getEnv().setAttribute("oai_formatName", mdFormatName);
		token.getEnv().setAttribute("oai_formatLayout", mdFormatLayout);
		token.getEnv().setAttribute("oai_formatInterpretation", mdFormatInterpretation);
		token.getEnv().setAttribute("oai_recordSource", datasource);
		return Arc.DEFAULT_ARC;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public String getMdFormatName() {
		return mdFormatName;
	}

	public void setMdFormatName(final String mdFormatName) {
		this.mdFormatName = mdFormatName;
	}

	public String getMdFormatLayout() {
		return mdFormatLayout;
	}

	public void setMdFormatLayout(final String mdFormatLayout) {
		this.mdFormatLayout = mdFormatLayout;
	}

	public String getMdFormatInterpretation() {
		return mdFormatInterpretation;
	}

	public void setMdFormatInterpretation(final String mdFormatInterpretation) {
		this.mdFormatInterpretation = mdFormatInterpretation;
	}

	public String getDatasource() {
		return datasource;
	}

	public void setDatasource(final String datasource) {
		this.datasource = datasource;
	}

	public String getMdstoreId() {
		return mdstoreId;
	}

	public void setMdstoreId(final String mdstoreId) {
		this.mdstoreId = mdstoreId;
	}

}
