package eu.dnetlib.msro.oai.workflows.nodes;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

/**
 * The Class PrepareOaiDataJobNode.
 */
public class PrepareOaiDataJobNode extends SimpleJobNode {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(PrepareOaiDataJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/** The service locator. */
	@Resource
	private UniqueServiceLocator serviceLocator;

	/** Target mongo oai store collection name. **/
	private String oaiStoreCollectionParam;

	/** Target mongo database name. **/
	private String oaiDBName;
	/** Name of the env property where to put the value of oaiDBName. **/
	private String oaiDBNameParam;

	private String formatParam = "oai_format";

	private String layoutParam = "oai_layout";

	private String interpretationParam = "oai_interpretation";

	private boolean skipDuplicates = false;
	private String duplicateXPath;

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final NodeToken token) throws Exception {

		log.info("start preparing job");

		// set the target mongo collection name
		String format = token.getEnv().getAttribute(getFormatParam());
		String interpretation = token.getEnv().getAttribute(getInterpretationParam());
		String layout = token.getEnv().getAttribute(getLayoutParam());
		token.getEnv().setAttribute(getOaiStoreCollectionParam(), format + "-" + layout + "-" + interpretation);

		String configurationProfile = getConfigurationProfile();
		token.getEnv().setAttribute("oaiConfiguration", configurationProfile);
		token.getEnv().setAttribute("oai.feed.date", DateUtils.now_ISO8601());

		token.getEnv().setAttribute(getOaiDBNameParam(), getOaiDBName());

		// services.publisher.oai.
		// duplicates
		token.getEnv().setAttribute("services.publisher.oai.skipDuplicates", skipDuplicates);
		token.getEnv().setAttribute("services.publisher.oai.duplicateXPath", duplicateXPath);

		return Arc.DEFAULT_ARC;
	}

	/**
	 * Gets the configuration profile.
	 * 
	 * @return the configuration profile
	 * @throws MSROException
	 *             the MSRO exception
	 */
	private String getConfigurationProfile() throws MSROException {
		try {
			return this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(
					"//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']");
		} catch (Exception e) {
			throw new MSROException("Cannot find OAI configuration profile", e);
		}
	}

	/**
	 * Gets the oai store collection param.
	 * 
	 * @return the oai store collection param
	 */
	public String getOaiStoreCollectionParam() {
		return oaiStoreCollectionParam;
	}

	/**
	 * Sets the oai store collection param.
	 * 
	 * @param oaiStoreCollectionParam
	 *            the new oai store collection param
	 */
	public void setOaiStoreCollectionParam(final String oaiStoreCollectionParam) {
		this.oaiStoreCollectionParam = oaiStoreCollectionParam;
	}

	public String getOaiDBName() {
		return oaiDBName;
	}

	public void setOaiDBName(final String oaiDBName) {
		this.oaiDBName = oaiDBName;
	}

	public String getOaiDBNameParam() {
		return oaiDBNameParam;
	}

	public void setOaiDBNameParam(final String oaiDBNameParam) {
		this.oaiDBNameParam = oaiDBNameParam;
	}

	public String getFormatParam() {
		return formatParam;
	}

	public void setFormatParam(final String formatParam) {
		this.formatParam = formatParam;
	}

	public String getLayoutParam() {
		return layoutParam;
	}

	public void setLayoutParam(final String layoutParam) {
		this.layoutParam = layoutParam;
	}

	public String getInterpretationParam() {
		return interpretationParam;
	}

	public void setInterpretationParam(final String interpretationParam) {
		this.interpretationParam = interpretationParam;
	}

	public boolean isSkipDuplicates() {
		return skipDuplicates;
	}

	public void setSkipDuplicates(final boolean skipDuplicates) {
		this.skipDuplicates = skipDuplicates;
	}

	public String getDuplicateXPath() {
		return duplicateXPath;
	}

	public void setDuplicateXPath(final String duplicateXPath) {
		this.duplicateXPath = duplicateXPath;
	}

}
