package eu.dnetlib.msro.oai.workflows.nodes;

import org.apache.commons.lang.StringUtils;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;

public class OAIEnsureIndexesJobNode extends AbstractOAIJobNode {

	private String oaiStoreCollectionParam;
	// overrides the value in the env param oaiStoreCollectionParam
	private String oaiStoreCollection;

	@Override
	void completePrepareJob(final BlackboardJob job, final NodeToken token) {

		job.setAction("ENSURE_INDEXES");
		job.getParameters().put("collection", getCollectionName(token));
	}

	private String getCollectionName(final NodeToken token) {
		if (StringUtils.isNotBlank(oaiStoreCollection)) return oaiStoreCollection;
		else {
			String collName = token.getEnv().getAttribute(getOaiStoreCollectionParam());
			if (collName == null) {
				collName = "";
			}
			return collName;
		}
	}

	public String getOaiStoreCollectionParam() {
		return oaiStoreCollectionParam;
	}

	public void setOaiStoreCollectionParam(final String oaiStoreCollectionParam) {
		this.oaiStoreCollectionParam = oaiStoreCollectionParam;
	}

	public String getOaiStoreCollection() {
		return oaiStoreCollection;
	}

	public void setOaiStoreCollection(final String oaiStoreCollection) {
		this.oaiStoreCollection = oaiStoreCollection;
	}

}
