package eu.dnetlib.msro.oai.workflows.nodes;

import org.apache.commons.lang.StringUtils;

import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;

public class OAIDropStoreJobNode extends AbstractOAIJobNode {

	private String formatParam, layoutParam, interpretationParam;
	// name of the env attribute where you can find the set name
	private String setSpecParam;
	private String setSpec;

	@Override
	void completePrepareJob(final BlackboardJob job, final NodeToken token) {
		job.setAction("DROP_STORE");
		job.getParameters().put("format", token.getEnv().getAttribute(formatParam));
		job.getParameters().put("layout", token.getEnv().getAttribute(layoutParam));
		job.getParameters().put("interpretation", token.getEnv().getAttribute(interpretationParam));
		String set = getTheSetName(token.getEnv());
		if (StringUtils.isNotBlank(set)) {
			job.getParameters().put("set", set);
		}
	}

	private String getTheSetName(final Env env) {
		if (StringUtils.isNotBlank(setSpec)) return setSpec;
		else return env.getAttribute(setSpecParam);

	}

	public String getFormatParam() {
		return formatParam;
	}

	public void setFormatParam(final String formatParam) {
		this.formatParam = formatParam;
	}

	public String getLayoutParam() {
		return layoutParam;
	}

	public void setLayoutParam(final String layoutParam) {
		this.layoutParam = layoutParam;
	}

	public String getInterpretationParam() {
		return interpretationParam;
	}

	public void setInterpretationParam(final String interpretationParam) {
		this.interpretationParam = interpretationParam;
	}

	public String getSetNameParam() {
		return setSpecParam;
	}

	public void setSetNameParam(final String setNameParam) {
		this.setSpecParam = setNameParam;
	}

	public String getSetName() {
		return setSpec;
	}

	public void setSetName(final String setName) {
		this.setSpec = setName;
	}

}
