package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;

public class OAICreateStoreJobNode extends AbstractOAIJobNode {

	private String formatParam, layoutParam, interpretationParam;

	@Override
	void completePrepareJob(final BlackboardJob job, final NodeToken token) {
		job.setAction("CREATE_STORE");
		job.getParameters().put("format", token.getEnv().getAttribute(formatParam));
		job.getParameters().put("layout", token.getEnv().getAttribute(layoutParam));
		job.getParameters().put("interpretation", token.getEnv().getAttribute(interpretationParam));
	}

	public String getFormatParam() {
		return formatParam;
	}

	public void setFormatParam(final String formatParam) {
		this.formatParam = formatParam;
	}

	public String getLayoutParam() {
		return layoutParam;
	}

	public void setLayoutParam(final String layoutParam) {
		this.layoutParam = layoutParam;
	}

	public String getInterpretationParam() {
		return interpretationParam;
	}

	public void setInterpretationParam(final String interpretationParam) {
		this.interpretationParam = interpretationParam;
	}

}
