package eu.dnetlib.msro.oai.workflows.nodes;

import org.apache.commons.lang.StringUtils;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;

public class OAICreateIndexJobNode extends AbstractOAIJobNode {

	private String oaiStoreCollectionParam;
	// overrides the value in the env param oaiStoreCollectionParam
	private String oaiStoreCollection;

	/**
	 * Name of the fields (comma separated) to be included in the same index. For several indexes separate the fieldNames with ;
	 * <p>
	 * Examples: field1,field2 -- one compound index on the given two fields field1,field2;field3,field4 -- two compound indices: one on
	 * field1 and field2, the other on field3 and field4
	 * </p>
	 * **/
	private String fieldNames;

	@Override
	public void completePrepareJob(final BlackboardJob job, final NodeToken token) {
		job.setAction("CREATE_OAI_INDEX");
		job.getParameters().put("collection", getCollectionName(token));
		job.getParameters().put("oai_index_fieldNames", fieldNames);
	}

	private String getCollectionName(final NodeToken token) {
		if (StringUtils.isNotBlank(oaiStoreCollection)) return oaiStoreCollection;
		else {
			String collName = token.getEnv().getAttribute(getOaiStoreCollectionParam());
			if (collName == null) {
				collName = "";
			}
			return collName;
		}
	}

	public String getFieldNames() {
		return fieldNames;
	}

	public void setFieldNames(final String fieldNames) {
		this.fieldNames = fieldNames;
	}

	public String getOaiStoreCollectionParam() {
		return oaiStoreCollectionParam;
	}

	public void setOaiStoreCollectionParam(final String oaiStoreCollectionParam) {
		this.oaiStoreCollectionParam = oaiStoreCollectionParam;
	}

	public String getOaiStoreCollection() {
		return oaiStoreCollection;
	}

	public void setOaiStoreCollection(final String oaiStoreCollection) {
		this.oaiStoreCollection = oaiStoreCollection;
	}

}
