package eu.dnetlib.msro.oai.workflows.nodes;

import org.apache.commons.lang.StringUtils;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.oai.store.OAIStoreService;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

public abstract class AbstractOAIJobNode extends BlackboardJobNode {

	private String dbNameParam;
	// overrides the value in the env param dbNameParam
	private String dbName;

	protected String getTheDBName(final NodeToken token) {
		if (StringUtils.isNotBlank(dbName)) {
			return dbName;
		} else {
			return token.getEnv().getAttribute(getDbNameParam());
		}
	}

	@Override
	protected String obtainServiceId(final NodeToken token) {
		return getServiceLocator().getServiceId(OAIStoreService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws ResultSetException {
		job.getParameters().put("oai_dbName", getTheDBName(token));
		completePrepareJob(job, token);
	}

	abstract void completePrepareJob(final BlackboardJob job, final NodeToken token) throws ResultSetException;

	public String getDbNameParam() {
		return dbNameParam;
	}

	public void setDbNameParam(final String dbNameParam) {
		this.dbNameParam = dbNameParam;
	}

	public String getDbName() {
		return dbName;
	}

	public void setDbName(final String dbName) {
		this.dbName = dbName;
	}
}
