/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.oai.workflows.nodes.AbstractOAIJobNode;
import org.apache.commons.lang.StringUtils;

public class OAISetsCountJobNode
extends AbstractOAIJobNode {
    private String configuredOnly;
    private String oaiStoreCollectionParam;
    private String oaiStoreCollection;

    @Override
    void completePrepareJob(BlackboardJob job, NodeToken token) {
        job.setAction("COUNT_SETS");
        job.getParameters().put("configuredOnly", this.configuredOnly);
        job.getParameters().put("collection", this.getCollectionName(token));
        job.getParameters().put("oai_dbName", token.getEnv().getAttribute("oai_dbName"));
    }

    private String getCollectionName(NodeToken token) {
        if (StringUtils.isNotBlank((String)this.oaiStoreCollection)) {
            return this.oaiStoreCollection;
        }
        String collName = token.getEnv().getAttribute(this.getOaiStoreCollectionParam());
        if (collName == null) {
            collName = "";
        }
        return collName;
    }

    public String getConfiguredOnly() {
        return this.configuredOnly;
    }

    public void setConfiguredOnly(String configuredOnly) {
        this.configuredOnly = configuredOnly;
    }

    public String getOaiStoreCollectionParam() {
        return this.oaiStoreCollectionParam;
    }

    public void setOaiStoreCollectionParam(String oaiStoreCollectionParam) {
        this.oaiStoreCollectionParam = oaiStoreCollectionParam;
    }

    public String getOaiStoreCollection() {
        return this.oaiStoreCollection;
    }

    public void setOaiStoreCollection(String oaiStoreCollection) {
        this.oaiStoreCollection = oaiStoreCollection;
    }
}

