/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareOaiDataJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareOaiDataJobNode.class);
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String oaiStoreCollectionParam;
    private String oaiDBName;
    private String oaiDBNameParam;
    private String formatParam = "oai_format";
    private String layoutParam = "oai_layout";
    private String interpretationParam = "oai_interpretation";

    protected String execute(NodeToken token) throws Exception {
        log.info((Object)"start preparing job");
        String format = token.getEnv().getAttribute(this.getFormatParam());
        String interpretation = token.getEnv().getAttribute(this.getInterpretationParam());
        String layout = token.getEnv().getAttribute(this.getLayoutParam());
        token.getEnv().setAttribute(this.getOaiStoreCollectionParam(), format + "-" + layout + "-" + interpretation);
        String configurationProfile = this.getConfigurationProfile();
        token.getEnv().setAttribute("oaiConfiguration", configurationProfile);
        token.getEnv().setAttribute("oai.feed.date", DateUtils.now_ISO8601());
        token.getEnv().setAttribute(this.getOaiDBNameParam(), this.getOaiDBName());
        return Arc.DEFAULT_ARC;
    }

    private String getConfigurationProfile() throws MSROException {
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']");
        }
        catch (Exception e) {
            throw new MSROException("Cannot find OAI configuration profile", (Throwable)e);
        }
    }

    public String getOaiStoreCollectionParam() {
        return this.oaiStoreCollectionParam;
    }

    public void setOaiStoreCollectionParam(String oaiStoreCollectionParam) {
        this.oaiStoreCollectionParam = oaiStoreCollectionParam;
    }

    public String getOaiDBName() {
        return this.oaiDBName;
    }

    public void setOaiDBName(String oaiDBName) {
        this.oaiDBName = oaiDBName;
    }

    public String getOaiDBNameParam() {
        return this.oaiDBNameParam;
    }

    public void setOaiDBNameParam(String oaiDBNameParam) {
        this.oaiDBNameParam = oaiDBNameParam;
    }

    public String getFormatParam() {
        return this.formatParam;
    }

    public void setFormatParam(String formatParam) {
        this.formatParam = formatParam;
    }

    public String getLayoutParam() {
        return this.layoutParam;
    }

    public void setLayoutParam(String layoutParam) {
        this.layoutParam = layoutParam;
    }

    public String getInterpretationParam() {
        return this.interpretationParam;
    }

    public void setInterpretationParam(String interpretationParam) {
        this.interpretationParam = interpretationParam;
    }
}

