/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetCurrentOAIDBJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(SetCurrentOAIDBJobNode.class);
    @Resource(name="registryLocator")
    private ServiceLocator<ISRegistryService> isRegistryLocator;
    private String oaiDBName;
    private String oaiDBNameParam;
    private String xpathToCurrentDB = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION/CURRENTDB";

    protected String getTheDBName(NodeToken token) {
        if (StringUtils.isNotBlank((String)this.oaiDBName)) {
            return this.oaiDBName;
        }
        return token.getEnv().getAttribute(this.oaiDBNameParam);
    }

    protected String execute(NodeToken token) throws Exception {
        String dbToSet = this.getTheDBName(token);
        log.fatal((Object)("Setting OAI Publisher to use db " + dbToSet));
        String xUpdate = "update value " + this.xpathToCurrentDB + " with '" + dbToSet + "'";
        ((ISRegistryService)this.isRegistryLocator.getService()).executeXUpdate(xUpdate);
        return Arc.DEFAULT_ARC;
    }

    public String getOaiDBName() {
        return this.oaiDBName;
    }

    public void setOaiDBName(String oaiDBName) {
        this.oaiDBName = oaiDBName;
    }

    public String getOaiDBNameParam() {
        return this.oaiDBNameParam;
    }

    public void setOaiDBNameParam(String oaiDBNameParam) {
        this.oaiDBNameParam = oaiDBNameParam;
    }

    public String getXpathToCurrentDB() {
        return this.xpathToCurrentDB;
    }

    public void setXpathToCurrentDB(String xpathToCurrentDB) {
        this.xpathToCurrentDB = xpathToCurrentDB;
    }
}

