<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
	xmlns:oai="http://www.openarchives.org/OAI/2.0/"
	xmlns:dnet="eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions"
	xmlns:oaf="http://namespace.openaire.eu/oaf"
	exclude-result-prefixes="xsl datetime exslt dnet xsi"
	xmlns:dri="http://www.driver-repository.eu/namespace/dri">

	<xsl:template match="/">
		<oai:record>
			<oai:header>
				<dri:objIdentifier><xsl:value-of select="concat('$namespacePrefix$::', dnet:md5($xpath$))"/></dri:objIdentifier>
				<dri:recordIdentifier><xsl:value-of select="$xpath$"/></dri:recordIdentifier>
				<dri:dateOfCollection><xsl:value-of select="datetime:dateTime()"/></dri:dateOfCollection>
				<dri:repositoryId>$datasourceId$</dri:repositoryId>
				<oaf:datasourceprefix>$namespacePrefix$</oaf:datasourceprefix>
				<xsl:for-each select="/*[local-name() = 'record']/*[local-name() = 'header']/*">
					<xsl:copy-of select="."/>
				</xsl:for-each>
			</oai:header>
			<xsl:choose>
				<xsl:when test="count(/*[local-name() = 'record']/*[local-name() = 'metadata']) &gt; 0">
					<xsl:copy-of select="/*[local-name() = 'record']/*[local-name() = 'metadata']"/>
				</xsl:when>
				<xsl:otherwise>
					<oai:metadata>
						<xsl:copy-of select="."/>
					</oai:metadata>
				</xsl:otherwise>
			</xsl:choose>
		</oai:record>
	</xsl:template>

</xsl:stylesheet>
