/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.resultset;

import com.google.common.collect.Lists;
import com.googlecode.sarasvati.GraphProcess;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetAware;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessCountingResultSetListener
implements ResultSetListener,
ResultSetAware {
    private int count;
    private GraphProcess process;
    private ResultSetService inputService;
    private String inputRsId;
    private ResultSet outputResulset;
    private int inputSize;
    private boolean inaccurate = false;
    private static final Log log = LogFactory.getLog(ProcessCountingResultSetListener.class);

    public ProcessCountingResultSetListener(GraphProcess process, ResultSetService inputService, String inputRsId) throws ResultSetException {
        this.process = process;
        this.inputService = inputService;
        this.inputRsId = inputRsId;
        this.inputSize = inputService.getNumberOfElements(inputRsId);
        this.count = 0;
    }

    public List<String> getResult(int from, int to) {
        if (this.process.isCanceled()) {
            this.outputResulset.close();
            return Lists.newArrayList();
        }
        try {
            this.count = to;
            if (this.count >= this.inputSize) {
                this.outputResulset.close();
            }
            return this.inputService.getResult(this.inputRsId, from, to, "WAITING");
        }
        catch (ResultSetException e) {
            log.error((Object)("Error fetching records from resultset: " + this.inputRsId));
            throw new RuntimeException(e);
        }
    }

    public int getSize() {
        if (this.process.isCanceled()) {
            this.outputResulset.close();
            return this.count;
        }
        try {
            int size = this.inputService.getNumberOfElements(this.inputRsId);
            if (this.inputSize != size) {
                this.inputSize = size;
                this.inaccurate = true;
            }
            this.inputSize = size;
            if (this.count >= this.inputSize) {
                this.outputResulset.close();
                this.inaccurate = false;
            }
            return this.inputSize;
        }
        catch (ResultSetException e) {
            log.error((Object)("Error fetching records from resultset: " + this.inputRsId));
            throw new RuntimeException(e);
        }
    }

    public void setResultSet(ResultSet outputResulset) {
        this.outputResulset = outputResulset;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isInaccurate() {
        return this.inaccurate;
    }
}

