/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.transform;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Required;

public class MdBuilderJobNode
extends SimpleJobNode {
    @Resource(name="mdBuilderTemplateXslt")
    private org.springframework.core.io.Resource mdBuilderTemplateXslt;
    private String inputEprParam;
    private String outputEprParam;
    private String datasourceId;
    private String datasourceInterface;
    private XSLTMappedResultSetFactory xsltMappedResultSetFactory;
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;

    @Override
    protected String execute(NodeToken token) throws MSROException {
        String inputEpr = token.getEnv().getAttribute(this.inputEprParam);
        if (inputEpr == null || inputEpr.isEmpty()) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        String xQuery = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') return $x//INTERFACE[@id='{interfaceId}']/INTERFACE_EXTRA_FIELD[@name='metadata_identifier_path']/string()";
        xQuery = xQuery.replace("{interfaceId}", this.datasourceInterface);
        try {
            StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.getMdBuilderTemplateXslt().getInputStream()));
            st.setAttribute("xpath", (Object)((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(xQuery));
            st.setAttribute("datasourceId", (Object)this.datasourceId);
            if (token.getEnv().hasAttribute("namespacePrefix")) {
                st.setAttribute("namespacePrefix", (Object)token.getEnv().getAttribute("namespacePrefix"));
            } else {
                st.setAttribute("namespacePrefix", (Object)this.datasourceId);
            }
            W3CEndpointReference epr = this.xsltMappedResultSetFactory.createMappedResultSet(new EPRUtils().getEpr(inputEpr), st.toString());
            token.getEnv().setAttribute(this.outputEprParam, epr.toString());
            return Arc.DEFAULT_ARC;
        }
        catch (ISLookUpDocumentNotFoundException e) {
            throw new MSROException("Missing metadata_identifier_path extra field for ds: " + this.datasourceId, (Throwable)e);
        }
        catch (ISLookUpException e) {
            throw new MSROException("Error searching metadata_identifier_path extra field for ds: " + this.datasourceId, (Throwable)e);
        }
        catch (IOException e) {
            throw new MSROException("Error parsing template: " + this.getMdBuilderTemplateXslt().getFilename(), (Throwable)e);
        }
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public XSLTMappedResultSetFactory getXsltMappedResultSetFactory() {
        return this.xsltMappedResultSetFactory;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    @Required
    public void setXsltMappedResultSetFactory(XSLTMappedResultSetFactory xsltMappedResultSetFactory) {
        this.xsltMappedResultSetFactory = xsltMappedResultSetFactory;
    }

    public org.springframework.core.io.Resource getMdBuilderTemplateXslt() {
        return this.mdBuilderTemplateXslt;
    }

    public void setMdBuilderTemplateXslt(org.springframework.core.io.Resource mdBuilderTemplateXslt) {
        this.mdBuilderTemplateXslt = mdBuilderTemplateXslt;
    }
}

