/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.repohi;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.metawf.DatasourceMetaWorkflow;
import eu.dnetlib.msro.workflows.metawf.DatasourceMetaWorkflowFactory;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateMetaWfJobNode
extends SimpleJobNode {
    @Resource(name="registryLocator")
    private ServiceLocator<ISRegistryService> registryLocator;
    @Resource
    private DatasourceMetaWorkflowFactory datasourceMetaWorkflowFactory;
    private String beanName;
    private static final Log log = LogFactory.getLog(UpdateMetaWfJobNode.class);

    @Override
    protected String execute(NodeToken token) throws Exception {
        String metaWfId = token.getFullEnv().getAttribute("META_WORKFLOW_ID");
        ((ISRegistryService)this.registryLocator.getService()).updateProfileNode(metaWfId, "//CONFIGURATION/@status", "'" + (Object)((Object)WorkflowsConstants.WorkflowStatus.WAIT_SYS_SETTINGS) + "'");
        HashMap map = Maps.newHashMap();
        for (String s : token.getFullEnv().getAttributeNames()) {
            map.put(s, token.getFullEnv().getAttribute(s));
        }
        for (String s : token.getEnv().getAttributeNames()) {
            map.put(s, token.getEnv().getAttribute(s));
        }
        DatasourceMetaWorkflow prototypeMetaWf = this.datasourceMetaWorkflowFactory.newMetaWorkflow(this.beanName);
        log.info((Object)("Updating metaWorkflow of type: " + this.beanName));
        int count = prototypeMetaWf.registerAllWorkflows(map);
        log.info((Object)("  -- Registered wfs: " + count));
        String repoByeId = prototypeMetaWf.registerDestroyWorkflow(map);
        log.info((Object)("  -- Repo Bye Wf: " + repoByeId));
        this.updateDatasourceWorkflow(metaWfId, repoByeId, prototypeMetaWf.asXML());
        log.info((Object)"Done");
        return Arc.DEFAULT_ARC;
    }

    protected boolean updateDatasourceWorkflow(String id, String repoByeId, String metawf) throws ISRegistryException, IOException {
        StringWriter sw = new StringWriter();
        sw.append("<CONFIGURATION status='");
        sw.append(WorkflowsConstants.WorkflowStatus.WAIT_USER_SETTINGS.toString());
        sw.append("' destroyWorkflow='");
        sw.append(repoByeId);
        sw.append("'>");
        sw.append(metawf);
        sw.append("</CONFIGURATION>");
        return ((ISRegistryService)this.registryLocator.getService()).updateProfileNode(id, "//CONFIGURATION", sw.toString());
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }
}

