/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Autowired;

public class MultipleMdStoreIterator
implements Iterable<String>,
Iterator<String> {
    private ServiceLocator<MDStoreService> mdstoreLocator;
    private List<String> mdIDs;
    private String currentId = null;
    private Iterator<String> currentIterator;
    @Autowired
    private ResultSetClientFactory resultSetClientFactory;

    public MultipleMdStoreIterator(ServiceLocator<MDStoreService> mdstoreLocator, List<String> mdIds, ResultSetClientFactory resultSetClientFactory) {
        this.mdstoreLocator = mdstoreLocator;
        this.mdIDs = mdIds;
        this.resultSetClientFactory = resultSetClientFactory;
    }

    @Override
    public Iterator<String> iterator() {
        this.getNextMDStoreRecords();
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.currentId == null || this.currentIterator == null) {
            return false;
        }
        if (!this.currentIterator.hasNext()) {
            this.getNextMDStoreRecords();
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public String next() {
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
    }

    private void getNextMDStoreRecords() {
        if (this.mdIDs.size() > 0) {
            this.currentId = this.mdIDs.remove(0);
            this.currentIterator = this.getIterableResultset(this.currentId);
        }
    }

    private Iterator<String> getIterableResultset(String id) {
        try {
            W3CEndpointReference epr = ((MDStoreService)this.mdstoreLocator.getService()).deliverMDRecords(id, "", "", "");
            IterableResultSetClient input = this.resultSetClientFactory.getClient(epr);
            return input.iterator();
        }
        catch (MDStoreServiceException e) {
            return null;
        }
    }
}

