/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.mdstore.MultipleMdStoreIterator;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class FetchMultipleMDStores
extends SimpleJobNode {
    private ServiceLocator<MDStoreService> mdstoreLocator;
    private List<String> mdId;
    private String mdFormat;
    private String eprParam;
    @Resource(name="iterableResultSetFactory")
    private IterableResultSetFactory resultSetFactory;
    @Autowired
    private ResultSetClientFactory resultSetClientFactory;

    @Override
    protected String execute(NodeToken token) throws Exception {
        if (this.getMdId() == null) {
            List mdIds = (List)new Gson().fromJson(token.getEnv().getAttribute("mdId"), List.class);
            this.setMdId(mdIds);
        }
        if (this.getMdFormat() == null) {
            this.setMdFormat(token.getEnv().getAttribute("mdFormat"));
        }
        MultipleMdStoreIterator iterators = new MultipleMdStoreIterator(this.mdstoreLocator, this.getMdId(), this.resultSetClientFactory);
        W3CEndpointReference eprUrls = this.resultSetFactory.createIterableResultSet((Iterable)iterators);
        token.getEnv().setAttribute(this.getEprParam(), eprUrls.toString());
        return Arc.DEFAULT_ARC;
    }

    public ServiceLocator<MDStoreService> getMdstoreLocator() {
        return this.mdstoreLocator;
    }

    @Required
    public void setMdstoreLocator(ServiceLocator<MDStoreService> mdstoreLocator) {
        this.mdstoreLocator = mdstoreLocator;
    }

    public List<String> getMdId() {
        return this.mdId;
    }

    public void setMdId(List<String> mdId) {
        this.mdId = mdId;
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

