/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class FetchMDStoreRecordsJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(FetchMDStoreRecordsJobNode.class);
    private ServiceLocator<MDStoreService> mdstoreLocator;
    private String mdId;
    private String mdFormat;
    private String eprParam;

    @Override
    protected String execute(NodeToken token) throws Exception {
        if (this.getMdId() == null) {
            this.setMdId(token.getEnv().getAttribute("mdId"));
        }
        if (this.getMdFormat() == null) {
            this.setMdFormat(token.getEnv().getAttribute("mdFormat"));
        }
        log.info((Object)("getting MDRecords from: " + this.getMdId()));
        W3CEndpointReference epr = ((MDStoreService)this.mdstoreLocator.getService()).deliverMDRecords(this.getMdId(), "", "", "");
        if (epr == null) {
            throw new MSROException("unable to read MDRecords from: " + this.getMdId());
        }
        token.getEnv().setAttribute(this.getEprParam(), epr.toString());
        return Arc.DEFAULT_ARC;
    }

    public ServiceLocator<MDStoreService> getMdstoreLocator() {
        return this.mdstoreLocator;
    }

    @Required
    public void setMdstoreLocator(ServiceLocator<MDStoreService> mdstoreLocator) {
        this.mdstoreLocator = mdstoreLocator;
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

