/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.info;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.datasource.common.utils.DatasourceUpdater;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.cxf.common.util.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class RemoveApiExtraFieldsJobNode
extends SimpleJobNode {
    private String datasourceId;
    private String datasourceInterface;
    private String fields;
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private DatasourceUpdater datasourceUpdater;

    @Override
    protected String execute(NodeToken token) throws Exception {
        if (!StringUtils.isEmpty((String)this.fields)) {
            HashSet invalidFields = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)this.fields.toLowerCase()));
            Map<String, String> map = this.calculateValidExtraFields(this.datasourceId, this.datasourceInterface, invalidFields);
            this.datasourceUpdater.updateApiExtraFields(this.datasourceId, this.datasourceInterface, map);
        }
        return Arc.DEFAULT_ARC;
    }

    private Map<String, String> calculateValidExtraFields(String repoId, String ifaceId, Set<String> invalidFields) throws Exception {
        HashMap res = Maps.newHashMap();
        SAXReader reader = new SAXReader();
        String profile = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(repoId);
        Document doc = reader.read((Reader)new StringReader(profile));
        Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
        if (ifcNode != null) {
            for (Object o : ifcNode.selectNodes("./INTERFACE_EXTRA_FIELD")) {
                String name = ((Node)o).valueOf("@name");
                if (invalidFields.contains(name.toLowerCase())) continue;
                res.put(name, ((Node)o).getText());
            }
        }
        return res;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public DatasourceUpdater getDatasourceUpdater() {
        return this.datasourceUpdater;
    }

    @Required
    public void setDatasourceUpdater(DatasourceUpdater datasourceUpdater) {
        this.datasourceUpdater = datasourceUpdater;
    }
}

