/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.index;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class UpdateIndexJobNode
extends BlackboardJobNode
implements ProgressJobNode {
    private static final Log log = LogFactory.getLog(UpdateIndexJobNode.class);
    private String eprParam;
    private String indexId;
    private String format;
    private String layout;
    private String feedingType;
    private String defaultIndexId;
    private XSLTMappedResultSetFactory xsltRSFactory;
    private ProcessCountingResultSetFactory processCountingResultSetFactory;
    private ResultsetProgressProvider progressProvider;
    private Resource layoutToRecordStylesheet;
    private ServiceLocator<ISLookUpService> lookupLocator;

    @Override
    protected String getXqueryForServiceId(NodeToken token) {
        return "collection('/db/DRIVER/ServiceResources/IndexServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()";
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) throws ResultSetException, ISLookUpException, IOException, TransformerException {
        log.info((Object)("preparing blackboard job update index: " + this.getIndexId()));
        W3CEndpointReference epr = new EPRUtils().getEpr(token.getEnv().getAttribute(this.getEprParam()));
        W3CEndpointReference mappedEpr = this.prepareForIndexing(epr, this.getFormat(), this.getLayout());
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), mappedEpr);
        job.setAction("FEED");
        job.getParameters().put("resultset_epr", this.encode(this.progressProvider.getEpr().toString()));
        job.getParameters().put("id", this.getIndexId());
        job.getParameters().put("feeding_type", this.getFeedingType());
        job.getParameters().put("backend_Id", this.defaultIndexId);
    }

    protected W3CEndpointReference prepareForIndexing(W3CEndpointReference mdStoreRsetEpr, String format, String layout) throws ISLookUpException, IOException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer layoutTransformer = factory.newTransformer(new StreamSource(this.getLayoutToRecordStylesheet().getInputStream()));
        DOMResult layoutToXsltXslt = new DOMResult();
        layoutTransformer.setParameter("format", format);
        layoutTransformer.transform(new StreamSource(new StringReader(this.getLayoutSource(format, layout))), layoutToXsltXslt);
        this.dumpXslt(factory, layoutToXsltXslt);
        return this.getXsltRSFactory().createMappedResultSet(mdStoreRsetEpr, (Source)new DOMSource(layoutToXsltXslt.getNode()), "dynamic layout xslt for " + format + ", " + layout);
    }

    private String getLayoutSource(String format, String layout) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        return ((ISLookUpService)this.getLookupLocator().getService()).getResourceProfileByQuery("collection('')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDFormatDSResourceType' and .//NAME='" + format + "']//LAYOUT[@name='" + layout + "']");
    }

    private void dumpXslt(TransformerFactory factory, DOMResult layoutToXsltXslt) throws TransformerConfigurationException, TransformerException {
        if (log.isDebugEnabled()) {
            StringWriter buffer = new StringWriter();
            factory.newTransformer().transform(new DOMSource(layoutToXsltXslt.getNode()), new StreamResult(buffer));
            log.debug((Object)buffer.toString());
        }
    }

    private String encode(String epr) {
        return new String(Base64.encodeBase64((byte[])epr.getBytes()));
    }

    public String getIndexId() {
        return this.indexId;
    }

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getFeedingType() {
        return this.feedingType;
    }

    public void setFeedingType(String feedingType) {
        this.feedingType = feedingType;
    }

    public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
        return this.processCountingResultSetFactory;
    }

    @Required
    public void setProcessCountingResultSetFactory(ProcessCountingResultSetFactory processCountingResultSetFactory) {
        this.processCountingResultSetFactory = processCountingResultSetFactory;
    }

    @Override
    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public Resource getLayoutToRecordStylesheet() {
        return this.layoutToRecordStylesheet;
    }

    @Required
    public void setLayoutToRecordStylesheet(Resource layoutToRecordStylesheet) {
        this.layoutToRecordStylesheet = layoutToRecordStylesheet;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public XSLTMappedResultSetFactory getXsltRSFactory() {
        return this.xsltRSFactory;
    }

    @Required
    public void setXsltRSFactory(XSLTMappedResultSetFactory xsltRSFactory) {
        this.xsltRSFactory = xsltRSFactory;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getDefaultIndexId() {
        return this.defaultIndexId;
    }

    @Required
    public void setDefaultIndexId(String defaultIndexId) {
        this.defaultIndexId = defaultIndexId;
    }
}

