/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.index;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class CreateIndexJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(CreateIndexJobNode.class);
    private String outputPrefix = "index_";
    private String defaultBackendId;
    private String format;
    private String layout;
    private String interpretation;

    @Override
    protected String getXqueryForServiceId(NodeToken token) {
        return "collection('/db/DRIVER/ServiceResources/IndexServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()";
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) {
        String env_format = token.getFullEnv().getAttribute("format");
        String env_layout = token.getFullEnv().getAttribute("layout");
        String env_interp = token.getFullEnv().getAttribute("interpretation");
        if (env_format != null && !env_format.isEmpty()) {
            this.format = env_format;
        }
        if (env_layout != null && !env_layout.isEmpty()) {
            this.layout = env_layout;
        }
        if (env_interp != null && !env_interp.isEmpty()) {
            this.interpretation = env_interp;
        }
        log.info((Object)("preparing CREATE blackboard job: " + this.format + "-" + this.layout + "-" + this.interpretation));
        job.setAction("CREATE");
        job.getParameters().put("format", this.format);
        job.getParameters().put("layout", this.layout);
        job.getParameters().put("interpretation", this.interpretation);
        job.getParameters().put("backend_Id", this.defaultBackendId);
    }

    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    public void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            @Override
            protected void populateEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute(CreateIndexJobNode.this.getOutputPrefix() + "format", CreateIndexJobNode.this.getFormat());
                env.setAttribute(CreateIndexJobNode.this.getOutputPrefix() + "layout", CreateIndexJobNode.this.getLayout());
                env.setAttribute(CreateIndexJobNode.this.getOutputPrefix() + "interpretation", CreateIndexJobNode.this.getInterpretation());
                env.setAttribute(CreateIndexJobNode.this.getOutputPrefix() + "id", responseParams.get("id"));
            }
        };
    }

    public String getDefaultBackendId() {
        return this.defaultBackendId;
    }

    @Required
    public void setDefaultBackendId(String defaultBackendId) {
        this.defaultBackendId = defaultBackendId;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }
}

