/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.harvest.fs;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.nodes.blackboard.OngoingBlackboardWorkflowJobListener;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StartHarvestFSJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(StartHarvestFSJobNode.class);
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private static final String protocol = "filesystem";
    private String datasourceId;
    private String username;
    private String password;
    private String filter;
    private String eprParam;
    private String datasourceInterface;
    private String format;

    @Override
    protected String getXqueryForServiceId(NodeToken token) {
        return "collection('/db/DRIVER/ServiceResources/HarvestingServiceResourceType')/RESOURCE_PROFILE[.//SERVICE_PROPERTIES/PROPERTY[@key='protocol']/@value = 'filesystem']//RESOURCE_IDENTIFIER/@value/string()";
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        job.setAction("LISTRECORDS");
        if (this.datasourceId == null || this.datasourceId.isEmpty()) {
            throw new MSROException("Missing field datasourceId");
        }
        job.getParameters().put("repository_id", this.getDatasourceId());
        if (this.datasourceInterface == null || this.datasourceInterface.isEmpty()) {
            throw new MSROException("Missing field datasourceInterface");
        }
        job.getParameters().put("base_url", this.obtainBaseUrl());
        if (this.format == null || this.format.isEmpty()) {
            throw new MSROException("Missing field format");
        }
        job.getParameters().put("inputFormat", this.format);
        if (this.username != null && !this.username.isEmpty()) {
            job.getParameters().put("username", this.getUsername());
        }
        if (this.password != null && !this.password.isEmpty()) {
            job.getParameters().put("password", this.getPassword());
        }
        if (this.filter != null && !this.filter.isEmpty()) {
            job.getParameters().put("filter", this.getFilter());
        }
    }

    private String obtainBaseUrl() throws ISLookUpDocumentNotFoundException, ISLookUpException {
        String query = "/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + this.getDatasourceId() + "']" + "//INTERFACE[@label='" + this.getDatasourceInterface() + "' and ./ACCESS_PROTOCOL = '" + protocol + "' and .//FORMAT = '" + this.getFormat() + "']/BASE_URL/text()";
        log.info((Object)("Executing query: " + query));
        return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new OngoingBlackboardWorkflowJobListener(engine, token){

            @Override
            protected void populateEnv(Env env, Map<String, String> responseParams) {
                log.info((Object)("Obtained epr: " + responseParams.get("rs_epr")));
                env.setAttribute(StartHarvestFSJobNode.this.getEprParam(), responseParams.get("rs_epr"));
            }
        };
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }
}

