/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.db;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Required;

public class ExecuteSqlJobNode
extends AsyncJobNode {
    private String db;
    private String dbParam;
    private String dbProperty;
    private String sql;
    private ServiceLocator<DatabaseService> dbServiceLocator;

    @Override
    protected String execute(NodeToken token) throws Exception {
        ((DatabaseService)this.dbServiceLocator.getService()).updateSQL(this.findDb(token), this.fetchSqlAsText(this.sql));
        return Arc.DEFAULT_ARC;
    }

    private String fetchSqlAsText(String path) throws IOException {
        return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(path));
    }

    private String findDb(NodeToken token) {
        if (this.dbParam != null && !this.dbParam.isEmpty()) {
            return token.getEnv().getAttribute(this.dbParam);
        }
        if (this.dbProperty != null && !this.dbProperty.isEmpty()) {
            return this.getPropertyFetcher().getProperty(this.dbProperty);
        }
        return this.db;
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getDbParam() {
        return this.dbParam;
    }

    public void setDbParam(String dbParam) {
        this.dbParam = dbParam;
    }

    public String getDbProperty() {
        return this.dbProperty;
    }

    public void setDbProperty(String dbProperty) {
        this.dbProperty = dbProperty;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public ServiceLocator<DatabaseService> getDbServiceLocator() {
        return this.dbServiceLocator;
    }

    @Required
    public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
        this.dbServiceLocator = dbServiceLocator;
    }
}

