/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.collect;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class DateRangeCollectRecordsJobNode
extends SimpleJobNode {
    private ServiceLocator<CollectorService> collectorLocator;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String datasourceId;
    private String datasourceInterface;
    private String eprParam;
    private String fromDateParam;
    private String untilDateParam;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String profile = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(this.datasourceId);
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + this.datasourceInterface + "']");
        String fromDate = token.getEnv().getAttribute(this.getFromDateParam());
        String untilDate = token.getEnv().getAttribute(this.getUntilDateParam());
        InterfaceDescriptor interfaceDescriptor = InterfaceDescriptor.newInstance((Node)ifcNode);
        W3CEndpointReference epr = ((CollectorService)this.collectorLocator.getService()).dateRangeCollect(interfaceDescriptor, fromDate, untilDate);
        token.getEnv().setAttribute(this.getEprParam(), epr.toString());
        return Arc.DEFAULT_ARC;
    }

    public String getFromDateParam() {
        return this.fromDateParam;
    }

    public void setFromDateParam(String fromDateParam) {
        this.fromDateParam = fromDateParam;
    }

    public String getUntilDateParam() {
        return this.untilDateParam;
    }

    public void setUntilDateParam(String untilDateParam) {
        this.untilDateParam = untilDateParam;
    }

    public ServiceLocator<CollectorService> getCollectorLocator() {
        return this.collectorLocator;
    }

    @Required
    public void setCollectorLocator(ServiceLocator<CollectorService> collectorLocator) {
        this.collectorLocator = collectorLocator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

