/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardClientHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobImpl;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobRegistry;
import eu.dnetlib.msro.workflows.nodes.SarasvatiJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BlackboardJobNode
extends SarasvatiJobNode {
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private static final Log log = LogFactory.getLog(BlackboardJobNode.class);
    @Resource
    private BlackboardClientHandler blackboardClientHandler;
    @Resource
    private BlackboardJobRegistry jobRegistry;

    @Override
    public void execute(Engine engine, NodeToken token) {
        super.execute(engine, token);
        log.info((Object)"executing blackboard node");
        try {
            token.getEnv().setAttribute("blackboard:isBlackboard", (Object)true);
            String query = this.getXqueryForServiceId(token);
            String serviceId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            if (StringUtils.isBlank((String)serviceId)) {
                token.getEnv().setAttribute("system:hasFailed", (Object)true);
                String msg = "cannot locate target service profile, using query: " + query;
                token.getEnv().setAttribute("system:error", msg);
                log.error((Object)msg);
                engine.complete(token, "failed");
                return;
            }
            BlackboardJob job = this.blackboardClientHandler.newJob(serviceId);
            token.getEnv().setTransientAttribute("blackboard:job", (Object)job);
            token.getEnv().setAttribute("blackboard:serviceId", ((BlackboardJobImpl)job).getServiceId());
            this.prepareJob(job, token);
            this.jobRegistry.registerJobListener(job, (BlackboardJobListener)this.generateBlackboardListener(engine, token));
            this.blackboardClientHandler.assign(job);
        }
        catch (Throwable e) {
            token.getEnv().setAttribute("system:hasFailed", (Object)true);
            token.getEnv().setAttribute("system:error", "cannot prepare blackboard job: " + e);
            engine.complete(token, "failed");
            log.error((Object)"cannot prepare blackboard job", e);
        }
    }

    protected abstract String getXqueryForServiceId(NodeToken var1);

    protected abstract void prepareJob(BlackboardJob var1, NodeToken var2) throws Exception;

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token);
    }
}

