/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.download;

import com.google.common.base.Function;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.DownloadItem;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class UrlExtractor
implements Function<String, String> {
    private static final Log log = LogFactory.getLog(UrlExtractor.class);
    private String xpath;
    private String xpathMetadataID;

    public UrlExtractor(String xpath, String xpathMetadataID) {
        this.xpath = xpath;
        this.xpathMetadataID = xpathMetadataID;
    }

    public String apply(String input) {
        try {
            DownloadItem di = new DownloadItem();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(input.getBytes()));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath myXpath = xPathFactory.newXPath();
            XPathExpression expression = myXpath.compile(this.xpath);
            Object values = expression.evaluate(doc, XPathConstants.NODESET);
            di.setUrl(this.getNodes((NodeList)values));
            di.setOriginalUrl(this.getNodes((NodeList)values));
            expression = myXpath.compile(this.xpathMetadataID);
            String extracted_metadataId = expression.evaluate(doc);
            di.setIdItemMetadata(extracted_metadataId);
            return di.toJSON();
        }
        catch (Exception e) {
            log.error((Object)"OPSSS... Something bad happen on evaluating ", (Throwable)e);
            return null;
        }
    }

    private String getNodes(NodeList nodes) {
        ArrayList<String> extracted_Url = new ArrayList<String>();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                extracted_Url.add(nodes.item(i).getNodeValue());
            }
        }
        return new Gson().toJson(extracted_Url);
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public String getXpathMetadataID() {
        return this.xpathMetadataID;
    }

    public void setXpathMetadataID(String xpathMetadataID) {
        this.xpathMetadataID = xpathMetadataID;
    }
}

