package eu.dnetlib.msro.workflows.nodes.transform;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.transformation.service.rmi.TransformationService;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class TransformJobNode extends SimpleJobNode {

	private String inputEprParam;
	private String outputEprParam;
	private String ruleId;

	@Autowired
	private ServiceLocator<TransformationService> transformationServiceLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final W3CEndpointReference inputEpr = (new EPRUtils()).getEpr(token.getEnv().getAttribute(inputEprParam));
		final W3CEndpointReference outputEpr = transformationServiceLocator.getService().transform(ruleId, inputEpr);

		token.getEnv().setAttribute(outputEprParam, outputEpr.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getRuleId() {
		return ruleId;
	}

	public void setRuleId(final String ruleId) {
		this.ruleId = ruleId;
	}

}
