package eu.dnetlib.msro.workflows.nodes.transform;

import java.io.IOException;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class MdBuilderJobNode extends SimpleJobNode {

	@javax.annotation.Resource(name = "mdBuilderTemplateXslt")
	private Resource mdBuilderTemplateXslt;

	private String inputEprParam;
	private String outputEprParam;
	private String datasourceId;
	private String datasourceInterface;

	private XSLTMappedResultSetFactory xsltMappedResultSetFactory;

	@javax.annotation.Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	@Override
	protected String execute(final NodeToken token) throws MSROException {
		final String inputEpr = token.getEnv().getAttribute(inputEprParam);
		
		if ((inputEpr == null) || inputEpr.isEmpty()) throw new MSROException("InputEprParam (" + inputEprParam + ") not found in ENV");
		
		String xQuery = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') "
				+ "return $x//INTERFACE[@id='{interfaceId}']/INTERFACE_EXTRA_FIELD[@name='metadata_identifier_path']/string()";
		xQuery = xQuery.replace("{interfaceId}", datasourceInterface);
		try {
			final StringTemplate st = new StringTemplate(IOUtils.toString(getMdBuilderTemplateXslt().getInputStream()));
			st.setAttribute("xpath", lookupLocator.getService().getResourceProfileByQuery(xQuery));
			st.setAttribute("datasourceId", datasourceId);
			if (token.getEnv().hasAttribute("namespacePrefix")) {
				st.setAttribute("namespacePrefix", token.getEnv().getAttribute("namespacePrefix"));
			} else {
				st.setAttribute("namespacePrefix", datasourceId);
			}
			final W3CEndpointReference epr = xsltMappedResultSetFactory.createMappedResultSet((new EPRUtils()).getEpr(inputEpr), st.toString());
	
			token.getEnv().setAttribute(outputEprParam, epr.toString());
	
			return Arc.DEFAULT_ARC;
		} catch (ISLookUpDocumentNotFoundException e) {
			throw new MSROException("Missing metadata_identifier_path extra field for ds: " + datasourceId, e);
		} catch (ISLookUpException e) {
			throw new MSROException("Error searching metadata_identifier_path extra field for ds: " + datasourceId, e);
		} catch (IOException e) {
			throw new MSROException("Error parsing template: " + getMdBuilderTemplateXslt().getFilename(), e);
		}
	}

	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public XSLTMappedResultSetFactory getXsltMappedResultSetFactory() {
		return xsltMappedResultSetFactory;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

	@Required
	public void setXsltMappedResultSetFactory(final XSLTMappedResultSetFactory xsltMappedResultSetFactory) {
		this.xsltMappedResultSetFactory = xsltMappedResultSetFactory;
	}

	public Resource getMdBuilderTemplateXslt() {
		return mdBuilderTemplateXslt;
	}

	public void setMdBuilderTemplateXslt(final Resource mdBuilderTemplateXslt) {
		this.mdBuilderTemplateXslt = mdBuilderTemplateXslt;
	}

}
