package eu.dnetlib.msro.workflows.nodes.repohi;

import javax.annotation.Resource;

import com.google.common.base.Splitter;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.datasource.common.utils.DefaultDatasourceUpdater;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class VerifyDatasourceJobNode extends SimpleJobNode {

	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	private String expectedInterfaceTypologyPrefixes;

	private String expectedCompliancePrefixes;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String dsId = token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_ID);
		final String ifaceId = token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE);

		String compliance;
		try {
			compliance = lookupLocator.getService().getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId + "']/INTERFACE_EXTRA_FIELD[@name='" + DefaultDatasourceUpdater.OVERRIDING_COMPLIANCE_FIELD + "']/text()");
		} catch(ISLookUpDocumentNotFoundException e) {
			compliance = lookupLocator.getService().getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId + "']/@compliance/string()");
		}
			
		final String typology = lookupLocator.getService().getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId + "']/@typology/string()");

		verifyValue(compliance, expectedCompliancePrefixes);
		verifyValue(typology , expectedInterfaceTypologyPrefixes);

		if (isPending(dsId)) return "validateDs";
		else return Arc.DEFAULT_ARC;
	}

	private void verifyValue(final String value, final String expected) throws Exception {
		if ((expected != null) && !expected.isEmpty()) {
			for (String s : Splitter.on(",").omitEmptyStrings().trimResults().split(expected)) {
				if (value.toLowerCase().startsWith(s.toLowerCase())) return;
			}
			throw new MSROException("Invalid value: " + value + ", Valid term prefixes are: [" + expected + "]");
		}
	}

	private boolean isPending(final String id) throws ISLookUpDocumentNotFoundException, ISLookUpException {
		final String query = "/*[.//RESOURCE_IDENTIFIER/@value='" + id + "']//RESOURCE_KIND/@value/string()";
		final String res = lookupLocator.getService().getResourceProfileByQuery(query);
		return res.trim().equals("PendingRepositoryResources");
	}

	public String getExpectedInterfaceTypologyPrefixes() {
		return expectedInterfaceTypologyPrefixes;
	}

	public void setExpectedInterfaceTypologyPrefixes(final String expectedInterfaceTypologyPrefixes) {
		this.expectedInterfaceTypologyPrefixes = expectedInterfaceTypologyPrefixes;
	}

	public String getExpectedCompliancePrefixes() {
		return expectedCompliancePrefixes;
	}

	public void setExpectedCompliancePrefixes(final String expectedCompliancePrefixes) {
		this.expectedCompliancePrefixes = expectedCompliancePrefixes;
	}

}
