package eu.dnetlib.msro.workflows.nodes.repobye;

import java.io.StringReader;
import java.io.StringWriter;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class DeleteMetaWfJobNode extends SimpleJobNode {

	private String metaWfId;

	@Resource(name = "registryLocator")
	private ServiceLocator<ISRegistryService> registryLocator;

	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	private static final Log log = LogFactory.getLog(DeleteMetaWfJobNode.class);

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String profile = lookupLocator.getService().getResourceProfile(metaWfId);
		final Document doc = (new SAXReader()).read(new StringReader(profile));

		final String dsId = doc.valueOf("//DATAPROVIDER/@id");
		final String dsName = doc.valueOf("//DATAPROVIDER/text()");
		final String ifaceId = doc.valueOf("//DATAPROVIDER/@interface");
		final String destroyWfId = doc.valueOf("//CONFIGURATION/@destroyWorkflow");

		log.info("Removing a MetaWf of dataprovider: " + dsId);

		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ID, dsId);
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAME, dsName);
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE, ifaceId);

		for (Object o : doc.selectNodes("//WORKFLOW")) {
			final String wfId = ((Node) o).valueOf("@id");
			try {
				registryLocator.getService().deleteProfile(wfId);
				log.info(" - Deleted Workflow: " + wfId);
			} catch (Exception e) {
				log.error(" - (ERR) Error deleting profile " + wfId);
			}
		}
		registryLocator.getService().deleteProfile(metaWfId);
		log.info(" - Deleted MetaWorkflow: " + metaWfId);

		registryLocator.getService().deleteProfile(destroyWfId);
		log.info(" - Deleted destroy workflow: " + destroyWfId);

		verifyDatasource(dsId, ifaceId);

		return Arc.DEFAULT_ARC;
	}

	private void verifyDatasource(final String dsId, final String ifaceId) throws Exception {
		final StringWriter sw = new StringWriter();

		sw.append("for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where");
		sw.append("  $x//DATAPROVIDER/@id = '" + dsId + "' and ");
		sw.append("  $x//DATAPROVIDER/@interface = '" + ifaceId + "' and ");
		sw.append("  $x//RESOURCE_IDENTIFIER/@value != '" + metaWfId + "' ");
		sw.append("return $x//RESOURCE_IDENTIFIER/@value/string()");

		final boolean active = !lookupLocator.getService().quickSearchProfile(sw.toString()).isEmpty();

		log.info(" - Updating iface, active status: " + active);

		updateIfaceActivationStatus(dsId, ifaceId, active);
	}

	protected void updateIfaceActivationStatus(final String dsId, final String ifaceId, final boolean active) throws Exception {
		registryLocator.getService().updateProfileNode(dsId, "//INTERFACE[@id = '" + ifaceId + "']/@active", "'" + active + "'");
	}

	public String getMetaWfId() {
		return metaWfId;
	}

	public void setMetaWfId(final String metaWfId) {
		this.metaWfId = metaWfId;
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

}
