package eu.dnetlib.msro.workflows.util;

public class WorkflowParam {

	private String name;
	private String value;
	private boolean required;
	private String type;
	private String function;
	
	public WorkflowParam() {
		
	}
	
	public WorkflowParam(final String name, final String value) {
		this(name, value, false, null, null);
	}

	public WorkflowParam(final String name, final String value, final boolean required, final String type, final String function) {
		this.name = ((name == null) || name.isEmpty()) ? "" : name;
		this.value = ((value == null) || value.isEmpty()) ? "" : value;
		this.required = required;
		this.type = ((type == null) || type.isEmpty()) ? "string" : type;
		this.function = function;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(final String value) {
		this.value = value;
	}

	public boolean isRequired() {
		return required;
	}

	public void setRequired(final boolean required) {
		this.required = required;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getFunction() {
		return function;
	}

	public void setFunction(final String function) {
		this.function = function;
	}

}
