package eu.dnetlib.msro.workflows.nodes.download;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

/**
 * The Class DownloadFromMetadata is a job node that send a blackboard message to the Download service to start to download file from url
 * retrieved by Metadata .
 */
public class DownloadFromMetadata extends BlackboardJobNode {

	/** The inputepr param. */
	private String inputeprParam;

	/** The obejct store id. */
	private String obejctStoreID;

	private String plugin;

	private String protocol;

	private String mimeType;

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.msro.workflows.nodes.BlackboardJobNode#getXqueryForServiceId(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return "//RESOURCE_IDENTIFIER[../RESOURCE_TYPE/@value='DownloadServiceResourceType']/@value/string()";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.msro.workflows.nodes.BlackboardJobNode#prepareJob(eu.dnetlib.enabling.tools.blackboard.BlackboardJob,
	 * com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction("DOWNLOAD");
		final String eprS = token.getEnv().getAttribute(getInputeprParam());
		job.getParameters().put("epr", eprS);
		job.getParameters().put("protocol", getProtocol());
		job.getParameters().put("plugin", getPlugin());
		job.getParameters().put("mimeType", getMimeType());
		job.getParameters().put("objectStoreID", getObejctStoreID());

	}

	/**
	 * Gets the inputepr param.
	 * 
	 * @return the inputeprParam
	 */
	public String getInputeprParam() {
		return inputeprParam;
	}

	/**
	 * Gets the obejct store id.
	 * 
	 * @return the obejctStoreID
	 */
	public String getObejctStoreID() {
		return obejctStoreID;
	}

	/**
	 * Sets the obejct store id.
	 * 
	 * @param obejctStoreID
	 *            the obejctStoreID to set
	 */
	public void setObejctStoreID(final String obejctStoreID) {
		this.obejctStoreID = obejctStoreID;
	}

	/**
	 * @return the plugin
	 */
	public String getPlugin() {
		return plugin;
	}

	/**
	 * @param plugin
	 *            the plugin to set
	 */
	public void setPlugin(final String plugin) {
		this.plugin = plugin;
	}

	/**
	 * @return the protol
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * @param protol
	 *            the protol to set
	 */
	public void setProtocol(final String protol) {
		this.protocol = protol;
	}

	/**
	 * @return the mimeType
	 */
	public String getMimeType() {
		return mimeType;
	}

	/**
	 * @param mimeType
	 *            the mimeType to set
	 */
	public void setMimeType(final String mimeType) {
		this.mimeType = mimeType;
	}

	/**
	 * @param inputeprParam
	 *            the inputeprParam to set
	 */
	public void setInputeprParam(final String inputeprParam) {
		this.inputeprParam = inputeprParam;
	}

}
