package eu.dnetlib.msro.workflows.nodes.db;

import java.io.IOException;

import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;

public class ExecuteSqlJobNode extends AsyncJobNode {
	private String db;
	private String dbParam;
	private String dbProperty;

	private String sql;
	
	private ServiceLocator<DatabaseService> dbServiceLocator;
	
	@Override
	protected String execute(NodeToken token) throws Exception {
		dbServiceLocator.getService().updateSQL(findDb(token), fetchSqlAsText(sql));
		
		return Arc.DEFAULT_ARC;
	}
	
	private String fetchSqlAsText(final String path) throws IOException {
		return IOUtils.toString(getClass().getResourceAsStream(path));
	}
	
	private String findDb(final NodeToken token) {
		if (dbParam != null && !dbParam.isEmpty()) {
			return token.getEnv().getAttribute(dbParam);
		} else if (dbProperty != null && !dbProperty.isEmpty()) {
			return getPropertyFetcher().getProperty(dbProperty);
		} else {
			return db;
		}
	}
	
	public String getDb() {
		return db;
	}

	public void setDb(String db) {
		this.db = db;
	}

	public String getDbParam() {
		return dbParam;
	}

	public void setDbParam(String dbParam) {
		this.dbParam = dbParam;
	}

	public String getDbProperty() {
		return dbProperty;
	}

	public void setDbProperty(String dbProperty) {
		this.dbProperty = dbProperty;
	}

	public String getSql() {
		return sql;
	}

	public void setSql(String sql) {
		this.sql = sql;
	}

	public ServiceLocator<DatabaseService> getDbServiceLocator() {
		return dbServiceLocator;
	}

	@Required
	public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
		this.dbServiceLocator = dbServiceLocator;
	}
	
}
