<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:wf="http://sarasvati.googlecode.com/ProcessDefinition">

	<xsl:template match="/">
		<xsl:variable name="wfname" select="translate(.//METAWORKFLOW_NAME, ' ', '_')" />

		<wf:process-definition name="{$wfname}">
			<xsl:apply-templates select=".//CONFIGURATION/WORKFLOW" />            
		</wf:process-definition>
	</xsl:template>

	<xsl:template match="WORKFLOW/WORKFLOW">
		<wf:node name="{@name}" type="WorkflowNode">
			<xsl:for-each select="./WORKFLOW">
				<wf:arc to="{@name}" />	
			</xsl:for-each>
			<wf:custom>
				<workflowId><xsl:value-of select="@id" /></workflowId>
			</wf:custom>
		</wf:node>
		<xsl:apply-templates select="./WORKFLOW" />
	</xsl:template>
	
	<xsl:template match="CONFIGURATION/WORKFLOW">
		<wf:node name="{@name}" type="WorkflowNode" isStart="true">
			<xsl:for-each select="./WORKFLOW">
				<wf:arc to="{@name}" />	
			</xsl:for-each>
			<wf:custom>
				<workflowId><xsl:value-of select="@id" /></workflowId>
			</wf:custom>
		</wf:node>
		<xsl:apply-templates select="./WORKFLOW" />
	</xsl:template>

</xsl:stylesheet>